/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.url.model;

import com.aliyun.securitysdk.url.model.SSRFMatcherMask;

public class SubnetMask
implements SSRFMatcherMask {
    private static final String IP_SEPARATOR = "/";
    private String address;
    private int mask;

    SubnetMask(String address, int mask) {
        this.address = address;
        this.mask = mask;
    }

    SubnetMask(String ip) {
        if (!ip.contains(IP_SEPARATOR)) {
            this.address = ip;
        } else {
            int indexOfSeperator = ip.indexOf(IP_SEPARATOR);
            this.address = ip.substring(0, indexOfSeperator);
            this.mask = Integer.parseInt(ip.substring(indexOfSeperator + 1));
        }
    }

    public String getAddress() {
        return this.address;
    }

    public int getMask() {
        return this.mask;
    }

    public String toString() {
        return "IpAddress{address='" + this.address + '\'' + ", mask=" + this.mask + '}';
    }

    public static String format(String ip, int mask) {
        if (ip == null || mask <= 0) {
            return null;
        }
        return new SubnetMask(ip, mask).format();
    }

    public static SubnetMask parse(String subnet) {
        if (subnet == null) {
            return null;
        }
        return new SubnetMask(subnet);
    }

    @Override
    public String format() {
        return this.address + IP_SEPARATOR + this.mask;
    }
}

