/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.mask;

import java.util.HashMap;
import java.util.Map;

public enum Scenario {
    Guest(1, "Guest"),
    Login(2, "Login"),
    Auth(3, "Auth"),
    Log(4, "Log");

    private final int index;
    private final String name;
    private static final Map<String, Scenario> stringToEnum;
    private static final Map<Integer, Scenario> indexToEnum;

    private Scenario(int index, String name) {
        this.index = index;
        this.name = name;
    }

    public static Scenario getByName(String name) {
        return stringToEnum.get(name);
    }

    public static Scenario getByIndex(int index) {
        return indexToEnum.get(index);
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static {
        stringToEnum = new HashMap<String, Scenario>();
        indexToEnum = new HashMap<Integer, Scenario>();
        for (Scenario scenario : Scenario.values()) {
            stringToEnum.put(scenario.toString(), scenario);
            indexToEnum.put(scenario.getIndex(), scenario);
        }
    }
}

