/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.mask;

import java.util.HashMap;
import java.util.Map;

public enum DataType {
    MobilePhone_Web_Cn(1, "MobilePhoneCN", "China mobile phone number"),
    MobilePhone_SMS_Cn(2, "MobilePhoneSMSCN", "China Mobile Phone number in sms"),
    MobilePhone_Web_Oversea(4, "MobilePhoneOversea", "Oversea mobile phone number"),
    MobilePhone_SMS_Oversea(5, "MobilePhoneOversea", "Oversea mobile phone number in sms"),
    Phone(10, "Phone", "Phone number"),
    Email_Web(11, "EmailWeb", "Web email"),
    Email_SMS(12, "EmailSMS", "SMS email"),
    DebitCard(13, "DebitCard", "Debit card"),
    Address(14, "Address", "Address"),
    NickName(15, "NickName", "Nick name"),
    Name(16, "Name", "Name"),
    IDCardNo(17, "IDCardNo", "ID card number"),
    Postcode(18, "Postcode", "Postcode number"),
    Email(19, "Email", "Email"),
    IDCardOversea(20, "IDCardOversea", "Oversea ID card number"),
    Default(21, "Default", "default"),
    EngineNumber(22, "EngineNumber", "Engine number"),
    VIN(23, "VIN", "Vehicle Identification Number"),
    NumberPlate(24, "NumberPlate", "Number-Plate"),
    IP_MAC(25, "IP_MAC", "IP or MAC address"),
    IMEI(26, "IP_MAC", "IP or MAC address"),
    Default_SMS(27, "Default_SMS", "Default for SMS"),
    NickName_SMS(28, "NickName_SMS", "Nickname for SMS"),
    CompanyName(29, "CompanyName", "Company name"),
    USCC(30, "UnifiedSocialCreditCode", "Unified Social Credit Code"),
    HW_QUANXI_SUBJECT(31, "HW_QUANXI_SUBJECT", "subject for quanxi account"),
    HW_QUANXI_EMAIL(32, "HW_QUANXI_EMAIL", "email for quanxi account");

    private final int index;
    private final String name;
    private final String description;
    private static final Map<String, DataType> STRING_TO_ENUM;
    private static final Map<Integer, DataType> INDEX_TO_ENUM;

    private DataType(int index, String name, String description) {
        this.index = index;
        this.name = name;
        this.description = description;
    }

    public static DataType getByName(String name) {
        return STRING_TO_ENUM.get(name);
    }

    public static DataType getByIndex(int index) {
        return INDEX_TO_ENUM.get(index);
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.name;
    }

    static {
        STRING_TO_ENUM = new HashMap<String, DataType>();
        INDEX_TO_ENUM = new HashMap<Integer, DataType>();
        for (DataType dataType : DataType.values()) {
            STRING_TO_ENUM.put(dataType.toString(), dataType);
            INDEX_TO_ENUM.put(dataType.getIndex(), dataType);
        }
    }
}

