/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.authorization.AuthorizationLogFactory;
import com.aliyun.securitysdk.authorization.AuthorizationLogger;
import com.aliyun.securitysdk.authorization.RiskLevel;
import com.aliyun.securitysdk.authorization.TargetType;
import com.aliyun.securitysdk.authorization.UserType;
import com.aliyun.securitysdk.cli.CLITool;
import com.aliyun.securitysdk.jdbc.Filter;
import com.aliyun.securitysdk.jdbc.JdbcTool;
import com.aliyun.securitysdk.jdbc.JdbcURLException;
import com.aliyun.securitysdk.mask.DataMaskingTool;
import com.aliyun.securitysdk.mask.DataType;
import com.aliyun.securitysdk.mask.Scenario;
import com.aliyun.securitysdk.mask.exception.CompleteTextNotAllowedException;
import com.aliyun.securitysdk.misc.MiscTool;
import com.aliyun.securitysdk.pass.PasswordTool;
import com.aliyun.securitysdk.path.PathFilter;
import com.aliyun.securitysdk.ql.QLTool;
import com.aliyun.securitysdk.ql.SLSQueryException;
import com.aliyun.securitysdk.sensitive.SensitiveDataClient;
import com.aliyun.securitysdk.sensitive.entity.SensitiveDataEnum;
import com.aliyun.securitysdk.sensitive.exception.SensitiveRuleNotCorrectException;
import com.aliyun.securitysdk.url.SSRFChecker;
import com.aliyun.securitysdk.url.SafeUrlChecker;
import com.aliyun.securitysdk.url.model.SSRFMatcherEnum;
import com.aliyun.securitysdk.url.ssrf.adaptor.HttpClientsAdaptor;
import com.aliyun.securitysdk.util.ServiceLoaderUtil;
import com.aliyun.securitysdk.xss.JsonpXssFilter;
import com.aliyun.securitysdk.xss.RichtextFilter;
import com.aliyun.securitysdk.xss.XssChecker;
import com.aliyun.securitysdk.xss.XssEscape;
import com.aliyun.securitysdk.xss.html.HtmlEscapeLevel;
import com.aliyun.securitysdk.xss.html.HtmlEscapeType;
import com.aliyun.securitysdk.xss.json.JsonEscapeLevel;
import com.aliyun.securitysdk.xss.json.JsonEscapeType;
import com.aliyun.securitysdk.xss.richtext.RichtextPolicy;
import com.aliyun.securitysdk.xss.richtext.XppScanner;
import com.aliyun.securitysdk.xxe.XxeTool;
import java.io.InputStream;
import java.util.List;
import java.util.Set;

public class SecurityUtil {
    private static final Logger logger = SecurityLogManager.getLogger(SecurityUtil.class);
    private static volatile XppScanner defaultXppScanner = null;

    public static void initialize() {
        try {
            Class.forName("com.aliyun.securitysdk.rass.net.AliyunSecurityNetHooksProvider");
        }
        catch (Throwable e) {
            logger.warn("ssrf initialize failed", e);
        }
    }

    private static void logSsrfResult(Object input, boolean output) {
        if (output) {
            logger.info("ssrf check: {}, result:true", input, (Object)output);
        } else {
            logger.warn("ssrf attack: {}", input);
        }
    }

    public static boolean checkSSRF(String url) {
        boolean result = SSRFCheckerHolder.CHECKER.checkSSRF(url);
        SecurityUtil.logSsrfResult(url, result);
        return result;
    }

    public static boolean checkSSRFWithoutConnection(String url) {
        boolean result = SSRFCheckerHolder.CHECKER.checkUrlWithoutConnection(url);
        SecurityUtil.logSsrfResult(url, result);
        return result;
    }

    public static boolean checkSSRFWithoutConnection(String url, boolean isIpAllowed) {
        boolean result = SSRFCheckerHolder.CHECKER.checkUrlWithoutConnection(url, isIpAllowed);
        SecurityUtil.logSsrfResult(url, result);
        return result;
    }

    public static boolean checkSSRF(String url, int checkTimes) {
        boolean result = SSRFCheckerHolder.CHECKER.checkUrl(url, checkTimes);
        SecurityUtil.logSsrfResult(url, result);
        return result;
    }

    public static void startSSRFNetHookChecking() {
        SSRFCheckerHolder.CHECKER.startNetHookWithThreadLocal();
    }

    public static void startSSRFNetHookChecking(String url) {
        SSRFCheckerHolder.CHECKER.startNetHookWithThreadLocal(url);
    }

    public static void stopSSRFNetHookChecking() {
        SSRFCheckerHolder.CHECKER.stopNetHookWithThreadLocal();
    }

    public static void startSSRFNetHookCheckingWithExpirationCache(String url) {
        SSRFCheckerHolder.CHECKER.startNetHookWithExpirationCache(url);
    }

    public static void startCustomNetHookWithExpirationCache(String url) {
        SSRFCheckerHolder.CHECKER.startCustomNetHookWithExpirationCache(url);
    }

    public static boolean checkSSRF(String url, int checkTimes, int timeout) {
        return SSRFCheckerHolder.CHECKER.checkUrl(url, checkTimes, timeout);
    }

    public static SSRFChecker getSSRFCheckerSingleton() {
        return SSRFCheckerHolder.CHECKER;
    }

    public static void addSSRFMasks(SSRFMatcherEnum ssrfMatcherEnum, String ... matcherMasks) {
        SSRFCheckerHolder.CHECKER.addCustomAllowedSubnetMasks(ssrfMatcherEnum, matcherMasks);
    }

    public static void addSSRFCustomAllowedSubnetMasks(SSRFMatcherEnum ssrfMatcherEnum, String ... matcherMasks) {
        SSRFCheckerHolder.CHECKER.addCustomAllowedSubnetMasks(ssrfMatcherEnum, matcherMasks);
    }

    public static void removeSSRFMasks(SSRFMatcherEnum ssrfMatcherEnum, String ... matcherMasks) {
        SSRFCheckerHolder.CHECKER.removeCustomAllowedSubnetMasks(ssrfMatcherEnum, matcherMasks);
    }

    public static void removeSSRFCustomAllowedSubnetMasks(SSRFMatcherEnum ssrfMatcherEnum, String ... matcherMasks) {
        SSRFCheckerHolder.CHECKER.removeCustomAllowedSubnetMasks(ssrfMatcherEnum, matcherMasks);
    }

    public static List<String> listAllSSRFMasks(SSRFMatcherEnum ssrfMatcherEnum) {
        return SSRFCheckerHolder.CHECKER.listAllMasks(ssrfMatcherEnum);
    }

    public static void configureSSRFMasks(SSRFMatcherEnum ssrfMatcherEnum, String ... matcherMasks) {
        SSRFCheckerHolder.CHECKER.configureMasks(ssrfMatcherEnum, matcherMasks);
    }

    public static SensitiveDataClient createSensitiveDataClient() throws SensitiveRuleNotCorrectException {
        return SensitiveDataHolder.TOOL.createClient();
    }

    public static SensitiveDataClient createSensitiveDataClient(SensitiveDataEnum sensitiveDataEnum) throws SensitiveRuleNotCorrectException {
        return SensitiveDataHolder.TOOL.createClient(sensitiveDataEnum);
    }

    public static SensitiveDataClient createSensitiveDataClient(List<String> ruleNames) throws SensitiveRuleNotCorrectException {
        return SensitiveDataHolder.TOOL.createClient(ruleNames);
    }

    public static SensitiveDataClient createSensitiveDataClient(String ruleFileName) throws SensitiveRuleNotCorrectException {
        return SensitiveDataHolder.TOOL.createClient(ruleFileName);
    }

    public static SensitiveDataClient createSensitiveDataClient(String ruleFileName, List<String> ruleNames) throws SensitiveRuleNotCorrectException {
        return SensitiveDataHolder.TOOL.createClient(ruleFileName, ruleNames);
    }

    public static String maskData(DataType dataType, Scenario scenario, String text) {
        return DataMaskingToolHolder.TOOL.mask(dataType, scenario, text);
    }

    public static String showCompleteText(DataType dataType, Scenario scenario, String text) throws CompleteTextNotAllowedException {
        return DataMaskingToolHolder.TOOL.mask(dataType, scenario, text, true);
    }

    public static AuthorizationLogger getAuthorizationLogger(String user, UserType userType, String target, TargetType targetType, RiskLevel riskLevel) {
        return AuthorizationLogFactory.getLogger(user, userType, target, targetType, riskLevel);
    }

    public static String filterJdbcConnectionSource(String url) throws JdbcURLException {
        return JdbcToolHolder.TOOL.filterConnectionSource(url);
    }

    public static void registerFilter(Filter filter) {
        JdbcToolHolder.TOOL.registerFilter(filter);
    }

    public static String buildSlsQuery(String systemQuery, String userQuery) throws SLSQueryException {
        return QLToolHolder.TOOL.buildSlsQuery(systemQuery, userQuery);
    }

    public static String escapeSql(String sql) {
        return QLToolHolder.TOOL.mysqlRealEscapeString(sql);
    }

    public static String trimSql(String sql) {
        return QLToolHolder.TOOL.trimSql(sql);
    }

    public static String trimSql4OrderBy(String sql) {
        return QLToolHolder.TOOL.trimSql4OrderBy(sql);
    }

    public static String escapeSlsSql(String unescapedString) {
        return QLToolHolder.TOOL.escapeSlsSql(unescapedString);
    }

    public static String trimCmd(String cmd) {
        return CLIToolHolder.TOOL.filter(cmd);
    }

    public static String getSafeCommandLine(String cmd) {
        return CLIToolHolder.TOOL.filter(cmd);
    }

    public static String pathFilter(String path) {
        return PathFilterHolder.TOOL.doFilter(path);
    }

    public static <T> T withSSRFChecking(T clientOrBuilder) {
        return SSRFAdaptorHolder.Adaptor.withSSRFChecking(clientOrBuilder);
    }

    public static <T> T withXxeProtection(T builder) {
        return XxeToolHolder.TOOL.withXxeProtection(builder);
    }

    public static boolean checkPasswordStrength(String password) {
        return PasswordToolHolder.TOOL.checkPasswordStrength(password);
    }

    public static boolean checkPasswordStrength(String password, boolean acceptCommonPassword) {
        return PasswordToolHolder.TOOL.checkPasswordStrength(password, acceptCommonPassword);
    }

    public static boolean isOssEndpointValid(String endpoint) {
        return MiscToolHolder.TOOL.isOssEndpointValid(endpoint);
    }

    public static boolean isRegionValid(String region) {
        return MiscToolHolder.TOOL.isRegionValid(region);
    }

    public static boolean isOssBucketValid(String bucket) {
        return MiscToolHolder.TOOL.isOssBucketValid(bucket);
    }

    public static String escapeHtml(String html) {
        String result = XssEscapeHolder.XSS_ESCAPE.escapeHtml(html);
        return result;
    }

    public static String escapeHtmlWithoutAmpersand(String html) {
        String result = XssEscapeHolder.XSS_ESCAPE.escapeHtmlWithoutAmpersand(html);
        return result;
    }

    public static String escapeXml(String xml) {
        String result = XssEscapeHolder.XSS_ESCAPE.escapeXml(xml);
        return result;
    }

    public static String escapeJson(String json) {
        return XssEscapeHolder.XSS_ESCAPE.escapeJson(json);
    }

    public static String escapeJsonWithoutAmpersand(String json) {
        return XssEscapeHolder.XSS_ESCAPE.escapeJsonWithoutAmpersand(json);
    }

    public static String escapeJson(Object json) {
        return XssEscapeHolder.XSS_ESCAPE.escapeJson(json);
    }

    public static String escapeJson(String json, JsonEscapeType type, JsonEscapeLevel level) {
        return XssEscapeHolder.XSS_ESCAPE.escapeJson(json, type, level);
    }

    public static String escapeJsonp(String jsonp) {
        return JsonpXssFilterHolder.JSONP_XSS_FILTER.escapeJsonp(jsonp);
    }

    public static void setDefaultJsonEscapeTypeForJsonp(JsonEscapeType jsonEscapeType) {
        JsonpXssFilterHolder.JSONP_XSS_FILTER.setDefaultJsonEscapeTypeForJsonp(jsonEscapeType);
    }

    public static void setDefaultJsonEscapeLevelForJsonp(JsonEscapeLevel jsonEscapeLevel) {
        JsonpXssFilterHolder.JSONP_XSS_FILTER.setDefaultJsonEscapeLevelForJsonp(jsonEscapeLevel);
    }

    public static void setDefaultHtmlEscapeLevelForJsonp(HtmlEscapeLevel htmlEscapeLevel) {
        JsonpXssFilterHolder.JSONP_XSS_FILTER.setDefaultHtmlEscapeLevelForJsonp(htmlEscapeLevel);
    }

    public static void setDefaultJsonEscapeTypeForJsonp(HtmlEscapeType htmlEscapeType) {
        JsonpXssFilterHolder.JSONP_XSS_FILTER.setDefaultHtmlEscapeTypeForJsonp(htmlEscapeType);
    }

    public static String escapeJavaScript(String js) {
        return XssEscapeHolder.XSS_ESCAPE.escapeJavaScript(js);
    }

    public static String escapeUri(String uri) {
        return XssEscapeHolder.XSS_ESCAPE.escapeUri(uri);
    }

    public static boolean addCustomProtocol(String protocol) {
        return XssEscapeHolder.XSS_ESCAPE.addCustomProtocol(protocol);
    }

    public static boolean removeCustomProtocol(String protocol) {
        return XssEscapeHolder.XSS_ESCAPE.removeCustomProtocol(protocol);
    }

    public static List<String> listUriAllowedProtocols() {
        return XssEscapeHolder.XSS_ESCAPE.listUriAllowedProtocols();
    }

    public static String richtext(String html) {
        if (html == null) {
            return null;
        }
        String output = defaultXppScanner == null ? RichtextFilterHolder.RICHTEXT_FILTER.richtext(html) : defaultXppScanner.scan(html);
        return output;
    }

    public static String richtext(Object obj) {
        if (obj == null) {
            return null;
        }
        String output = defaultXppScanner == null ? RichtextFilterHolder.RICHTEXT_FILTER.richtext(obj.toString()) : defaultXppScanner.scan(obj.toString());
        return output;
    }

    public static String fastRichtext(String html) {
        if (html == null) {
            return null;
        }
        String output = defaultXppScanner == null ? RichtextFilterHolder.RICHTEXT_FILTER.fastRichtext(html) : RichtextFilterHolder.RICHTEXT_FILTER.fastRichtext(defaultXppScanner, html);
        return output;
    }

    public static void setDefaultXssXppScannerPolicy(RichtextPolicy policy) {
        if (policy != null) {
            defaultXppScanner = RichtextFilterHolder.RICHTEXT_FILTER.getXppScannerInstanceByInternalDefinePolicy(policy);
        }
    }

    public static String getSafeUrl(String url) {
        return SafeUrlCheckerHolder.CHECKER.getSafeUrl(url);
    }

    public static String getSafeImgUrl(String url, Set<String> allowedImgExtensions, InputStream inputStream) {
        return SafeUrlCheckerHolder.CHECKER.getSafeImgUrl(url, allowedImgExtensions, inputStream);
    }

    public String getSafeUrlWithStrictStrategy(String url) {
        return SafeUrlCheckerHolder.CHECKER.getSafeUrlWithStrictStrategy(url);
    }

    private static class SafeUrlCheckerHolder {
        static final SafeUrlChecker CHECKER = ServiceLoaderUtil.newInstance(SafeUrlChecker.class, "com.aliyun.securitysdk.url.safeurl.ShadedSafeUrlChecker");

        private SafeUrlCheckerHolder() {
        }
    }

    private static class RichtextFilterHolder {
        static final RichtextFilter RICHTEXT_FILTER = ServiceLoaderUtil.newInstance(RichtextFilter.class, "com.aliyun.securitysdk.xss.ShadedRichtextFilter");

        private RichtextFilterHolder() {
        }
    }

    private static class JsonpXssFilterHolder {
        static final JsonpXssFilter JSONP_XSS_FILTER = ServiceLoaderUtil.newInstance(JsonpXssFilter.class, "com.aliyun.securitysdk.xss.ShadedJsonpXssFilter");

        private JsonpXssFilterHolder() {
        }
    }

    private static class XssCheckerHolder {
        static final XssChecker XSS_CHECKER = ServiceLoaderUtil.newInstance(XssChecker.class, "com.aliyun.securitysdk.xss.ShadedXssChecker");

        private XssCheckerHolder() {
        }
    }

    private static class XssEscapeHolder {
        static final XssEscape XSS_ESCAPE = ServiceLoaderUtil.newInstance(XssEscape.class, "com.aliyun.securitysdk.xss.ShadedXssEscape");

        private XssEscapeHolder() {
        }
    }

    public static class MiscToolHolder {
        static final MiscTool TOOL = ServiceLoaderUtil.newInstance(MiscTool.class, "com.aliyun.securitysdk.misc.MiscToolImpl");
    }

    public static class PasswordToolHolder {
        static final PasswordTool TOOL = ServiceLoaderUtil.newInstance(PasswordTool.class, "com.aliyun.securitysdk.pass.PasswordToolImpl");
    }

    public static class XxeToolHolder {
        static final XxeTool TOOL = ServiceLoaderUtil.newInstance(XxeTool.class, "com.aliyun.securitysdk.xxe.XxeToolImpl");
    }

    public static class SSRFAdaptorHolder {
        static final HttpClientsAdaptor Adaptor = ServiceLoaderUtil.newInstance(HttpClientsAdaptor.class, "com.aliyun.securitysdk.url.ssrf.adaptor.SSRFAdaptor");
    }

    public static class PathFilterHolder {
        static final PathFilter TOOL = ServiceLoaderUtil.newInstance(PathFilter.class, "com.aliyun.securitysdk.path.PathFilterImpl");
    }

    public static class CLIToolHolder {
        static final CLITool TOOL = ServiceLoaderUtil.newInstance(CLITool.class, "com.aliyun.securitysdk.cli.CLIToolImpl");
    }

    private static class QLToolHolder {
        static final QLTool TOOL = ServiceLoaderUtil.newInstance(QLTool.class, "com.aliyun.securitysdk.ql.QLToolImpl");

        private QLToolHolder() {
        }
    }

    private static class JdbcToolHolder {
        static final JdbcTool TOOL = ServiceLoaderUtil.newInstance(JdbcTool.class, "com.aliyun.securitysdk.jdbc.JdbcToolImpl");

        private JdbcToolHolder() {
        }
    }

    private static class SensitiveDataHolder {
        static final SensitiveDataClient TOOL = ServiceLoaderUtil.newInstance(SensitiveDataClient.class, "com.aliyun.securitysdk.sensitive.SensitiveDataClientImpl");

        private SensitiveDataHolder() {
        }
    }

    private static class DataMaskingToolHolder {
        static final DataMaskingTool TOOL = ServiceLoaderUtil.newInstance(DataMaskingTool.class, "com.aliyun.securitysdk.mask.DataMaskingToolImpl");

        private DataMaskingToolHolder() {
        }
    }

    private static class SSRFCheckerHolder {
        static final SSRFChecker CHECKER = ServiceLoaderUtil.newInstance(SSRFChecker.class, "com.aliyun.securitysdk.url.ssrf.SSRFCheckerImpl");

        private SSRFCheckerHolder() {
        }
    }
}

