/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.javax.xml.parsers;

import com.alibaba.securitysdk.javax.xml.parsers.FilePathToURI;
import com.alibaba.securitysdk.javax.xml.validation.Schema;
import com.alibaba.securitysdk.org.w3c.dom.DOMImplementation;
import com.alibaba.securitysdk.org.w3c.dom.Document;
import com.alibaba.securitysdk.org.xml.sax.EntityResolver;
import com.alibaba.securitysdk.org.xml.sax.ErrorHandler;
import com.alibaba.securitysdk.org.xml.sax.InputSource;
import com.alibaba.securitysdk.org.xml.sax.SAXException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public abstract class DocumentBuilder {
    private static final boolean DEBUG = false;

    protected DocumentBuilder() {
    }

    public void reset() {
        throw new UnsupportedOperationException("This DocumentBuilder, \"" + this.getClass().getName() + "\", does not support the reset functionality." + "  Specification \"" + this.getClass().getPackage().getSpecificationTitle() + "\"" + " version \"" + this.getClass().getPackage().getSpecificationVersion() + "\"");
    }

    public Document parse(InputStream is) throws SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        InputSource in = new InputSource(is);
        return this.parse(in);
    }

    public Document parse(InputStream is, String systemId) throws SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        InputSource in = new InputSource(is);
        in.setSystemId(systemId);
        return this.parse(in);
    }

    public Document parse(String uri) throws SAXException, IOException {
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        InputSource in = new InputSource(uri);
        return this.parse(in);
    }

    public Document parse(File f) throws SAXException, IOException {
        if (f == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        String escapedURI = FilePathToURI.filepath2URI(f.getAbsolutePath());
        InputSource in = new InputSource(escapedURI);
        return this.parse(in);
    }

    public abstract Document parse(InputSource var1) throws SAXException, IOException;

    public abstract boolean isNamespaceAware();

    public abstract boolean isValidating();

    public abstract void setEntityResolver(EntityResolver var1);

    public abstract void setErrorHandler(ErrorHandler var1);

    public abstract Document newDocument();

    public abstract DOMImplementation getDOMImplementation();

    public Schema getSchema() {
        throw new UnsupportedOperationException("This parser does not support specification \"" + this.getClass().getPackage().getSpecificationTitle() + "\" version \"" + this.getClass().getPackage().getSpecificationVersion() + "\"");
    }

    public boolean isXIncludeAware() {
        throw new UnsupportedOperationException("This parser does not support specification \"" + this.getClass().getPackage().getSpecificationTitle() + "\" version \"" + this.getClass().getPackage().getSpecificationVersion() + "\"");
    }
}

