/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.transform.shell.module;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import java.util.Arrays;
import java.util.List;

public enum ShellScriptType {
    PLAINTEXT("PlainText", "", CodeProgramType.VIRTUAL),
    PYTHON("Python", "python", CodeProgramType.PYODPS3, CodeProgramType.PYODPS),
    DI("DI", "sqoop", CodeProgramType.DI),
    SQL("Sql", "impala-shell,hive", CodeProgramType.ODPS_SQL, CodeProgramType.COMPONENT_SQL, CodeProgramType.EMR_SPARK_SQL, CodeProgramType.EMR_IMPALA),
    SHELL("Shell", "", CodeProgramType.SHELL, CodeProgramType.DIDE_SHELL, CodeProgramType.EMR_SHELL, CodeProgramType.CDH_SHELL);

    String name;
    List<String> cmdKeyWord;
    List<CodeProgramType> targetTypes;

    private ShellScriptType(String name, String cmdKeyWord) {
        this.name = name;
        this.cmdKeyWord = Arrays.stream(cmdKeyWord.split(",")).toList();
        this.targetTypes = null;
    }

    private ShellScriptType(String name, String cmdKeyWord, CodeProgramType ... types) {
        this.name = name;
        this.cmdKeyWord = Arrays.stream(cmdKeyWord.split(",")).toList();
        this.targetTypes = List.of(types);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getCmdKeyWord() {
        return this.cmdKeyWord;
    }

    public List<CodeProgramType> getTargetTypes() {
        return this.targetTypes;
    }

    public static ShellScriptType getTypeByName(String name) {
        for (ShellScriptType type : ShellScriptType.values()) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return PLAINTEXT;
    }

    public static ShellScriptType getTypeByCmdKeyWord(String cmdKeyWord) {
        for (ShellScriptType type : ShellScriptType.values()) {
            if (!type.getCmdKeyWord().contains(cmdKeyWord)) continue;
            return type;
        }
        return PLAINTEXT;
    }

    public static ShellScriptType getTypeByTargetType(CodeProgramType codeProgramType) {
        for (ShellScriptType type : ShellScriptType.values()) {
            if (type.getTargetTypes() == null || !type.getTargetTypes().contains(codeProgramType)) continue;
            return type;
        }
        return PLAINTEXT;
    }
}

