/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.util.matcher.bm;

import com.aliyun.securitysdk.rass.util.matcher.bm.CharIntMap;
import com.aliyun.securitysdk.rass.util.matcher.bm.MismatchSearch;

public abstract class StringSearch {
    private static final int CROSSOVER_MACOSX = 50;
    private static int crossover = 0;
    static StringAccess activeStringAccess = new StringAccess();

    public static boolean usesReflection() {
        return false;
    }

    public static char[] getChars(String s) {
        return activeStringAccess.getChars(s);
    }

    protected StringSearch() {
    }

    public abstract Object processBytes(byte[] var1);

    public abstract Object processChars(char[] var1);

    public Object processString(String pattern) {
        return this.processChars(StringSearch.getChars(pattern));
    }

    public final int searchBytes(byte[] text, byte[] pattern) {
        return this.searchBytes(text, 0, text.length, pattern, this.processBytes(pattern));
    }

    public final int searchBytes(byte[] text, byte[] pattern, Object processed) {
        return this.searchBytes(text, 0, text.length, pattern, processed);
    }

    public final int searchBytes(byte[] text, int textStart, byte[] pattern) {
        return this.searchBytes(text, textStart, text.length, pattern, this.processBytes(pattern));
    }

    public final int searchBytes(byte[] text, int textStart, byte[] pattern, Object processed) {
        return this.searchBytes(text, textStart, text.length, pattern, processed);
    }

    public final int searchBytes(byte[] text, int textStart, int textEnd, byte[] pattern) {
        return this.searchBytes(text, textStart, textEnd, pattern, this.processBytes(pattern));
    }

    public abstract int searchBytes(byte[] var1, int var2, int var3, byte[] var4, Object var5);

    public final int searchChars(char[] text, char[] pattern) {
        return this.searchChars(text, 0, text.length, pattern, this.processChars(pattern));
    }

    public final int searchChars(char[] text, char[] pattern, Object processed) {
        return this.searchChars(text, 0, text.length, pattern, processed);
    }

    public final int searchChars(char[] text, int textStart, char[] pattern) {
        return this.searchChars(text, textStart, text.length, pattern, this.processChars(pattern));
    }

    public final int searchChars(char[] text, int textStart, char[] pattern, Object processed) {
        return this.searchChars(text, textStart, text.length, pattern, processed);
    }

    public final int searchChars(char[] text, int textStart, int textEnd, char[] pattern) {
        return this.searchChars(text, textStart, textEnd, pattern, this.processChars(pattern));
    }

    public abstract int searchChars(char[] var1, int var2, int var3, char[] var4, Object var5);

    public final int searchString(String text, String pattern) {
        return this.searchString(text, 0, text.length(), pattern);
    }

    public final int searchString(String text, String pattern, Object processed) {
        return this.searchString(text, 0, text.length(), pattern, processed);
    }

    public final int searchString(String text, int textStart, String pattern) {
        return this.searchString(text, textStart, text.length(), pattern);
    }

    public final int searchString(String text, int textStart, String pattern, Object processed) {
        return this.searchString(text, textStart, text.length(), pattern, processed);
    }

    public final int searchString(String text, int textStart, int textEnd, String pattern) {
        return activeStringAccess.searchString(text, textStart, textEnd, pattern, this);
    }

    public final int searchString(String text, int textStart, int textEnd, String pattern, Object processed) {
        return activeStringAccess.searchString(text, textStart, textEnd, pattern, processed, this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass().getName().equals(obj.getClass().getName());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected final CharIntMap createCharIntMap(char[] pattern, int defaultValue) {
        return this.createCharIntMap(pattern, pattern.length, defaultValue);
    }

    protected final CharIntMap createCharIntMap(char[] pattern, int patternEnd, int defaultValue) {
        char min = '\uffff';
        char max = '\u0000';
        for (int i = 0; i < patternEnd; ++i) {
            max = max > pattern[i] ? max : pattern[i];
            min = min < pattern[i] ? min : pattern[i];
        }
        return new CharIntMap(max - min + 1, min, defaultValue);
    }

    protected final int index(byte idx) {
        return idx & 0xFF;
    }

    static class StringAccess {
        private StringAccess() {
        }

        int searchString(String text, int textStart, int textEnd, String pattern, Object processed, StringSearch instance) {
            return instance.searchChars(text.toCharArray(), textStart, textEnd, pattern.toCharArray(), processed);
        }

        int searchString(String text, int textStart, int textEnd, String pattern, StringSearch instance) {
            return instance.searchChars(text.toCharArray(), textStart, textEnd, pattern.toCharArray());
        }

        int[] searchString(String text, int textStart, int textEnd, String pattern, int k, MismatchSearch instance) {
            return instance.searchChars(text.toCharArray(), textStart, textEnd, pattern.toCharArray(), k);
        }

        int[] searchString(String text, int textStart, int textEnd, String pattern, Object processed, int k, MismatchSearch instance) {
            return instance.searchChars(text.toCharArray(), textStart, textEnd, pattern.toCharArray(), processed, k);
        }

        char[] getChars(String s) {
            return s.toCharArray();
        }
    }
}

