/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.util;

import com.aliyun.securitysdk.rass.util.ClassUtils;
import com.aliyun.securitysdk.rass.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.net.InetAddress;

public class InetAddressResolver {
    private static final String HOLDER_FIELD_NAME = "holder";
    private static final String HOLDER_CLASS = "java.net.InetAddress$InetAddressHolder";
    private static final String HOLDER_HOSTNAME_FIELD_NAME = "hostName";
    private static final Field HOLDER_FIELD = ReflectionUtils.findField(InetAddress.class, "holder");
    private static final Field HOST_NAME_FIELD;

    public String findInetAddressHoldingHostName(InetAddress inetAddress) {
        if (inetAddress == null) {
            return null;
        }
        return (String)ReflectionUtils.getNestedFieldValue(inetAddress, HOLDER_FIELD, HOST_NAME_FIELD);
    }

    static {
        HOLDER_FIELD.setAccessible(true);
        Class<?> holderClass = ClassUtils.forNameQuietly(HOLDER_CLASS, InetAddress.class.getClassLoader());
        HOST_NAME_FIELD = ReflectionUtils.findField(holderClass, HOLDER_HOSTNAME_FIELD_NAME);
        HOST_NAME_FIELD.setAccessible(true);
    }
}

