/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.permission.checker;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.api.CheckResult;
import com.aliyun.securitysdk.rass.api.Permission;
import com.aliyun.securitysdk.rass.api.PermissionMode;
import com.aliyun.securitysdk.rass.api.condition.Action;
import com.aliyun.securitysdk.rass.api.condition.action.FileAction;
import com.aliyun.securitysdk.rass.api.exception.PermissionException;
import com.aliyun.securitysdk.rass.api.ext.BooleanCheckResult;
import com.aliyun.securitysdk.rass.api.util.OsUtils;
import com.aliyun.securitysdk.rass.permission.FilePermission;
import com.aliyun.securitysdk.rass.permission.checker.BasePermissionChecker;
import com.aliyun.securitysdk.rass.util.StackTraceUtils;
import com.aliyun.securitysdk.rass.util.matcher.StringMatcher;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class FilePermissionChecker
extends BasePermissionChecker<FilePermission> {
    private static final Logger logger = SecurityLogManager.getLogger(FilePermissionChecker.class);
    private StringMatcher allowedMatcher;
    private StringMatcher disallowedMatcher;

    public FilePermissionChecker(StringMatcher allowedMatcher, StringMatcher disallowedMatcher, PermissionMode permissionMode, boolean enabled, Action ... actions) {
        super(enabled, "file checker", permissionMode, actions);
        this.allowedMatcher = allowedMatcher;
        this.disallowedMatcher = disallowedMatcher;
    }

    public boolean checkPermission(Permission<File> permission) {
        String targetPath = FilePermissionChecker.normalize((File)permission.getResource());
        if (targetPath == null) {
            if (OsUtils.IS_OS_WINDOWS) {
                targetPath = ((File)permission.getResource()).getAbsolutePath();
            } else {
                return false;
            }
        }
        if (!this.isEnabledStack()) {
            return true;
        }
        if (!this.shouldCheck(permission)) {
            return true;
        }
        if (this.checkAllowStack()) {
            return true;
        }
        if (this.checkDisallowStack()) {
            return false;
        }
        return this.allowedMatcher.matches(targetPath) || !this.disallowedMatcher.matches(targetPath);
    }

    public CheckResult observe(FilePermission permission) {
        boolean b = this.checkPermission((Permission<File>)permission);
        if (!b) {
            logger.info("[observe] check file permission: " + permission.getResource() + " : " + b);
        }
        return BooleanCheckResult.of((boolean)this.checkPermission((Permission<File>)permission));
    }

    public CheckResult handle(FilePermission permission) {
        boolean b = this.checkPermission((Permission<File>)permission);
        if (b) {
            return BooleanCheckResult.of((boolean)this.checkPermission((Permission<File>)permission));
        }
        logger.info("[block] check file permission: " + permission.getResource() + " : " + b + "\nStackTrace:\n" + StackTraceUtils.stackTraceAsString(Thread.currentThread().getStackTrace()));
        throw new PermissionException("The file access of [" + permission.getResource() + "] has been denied.");
    }

    private static String normalize(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    public List<Action> getDefaultActionList() {
        return Arrays.asList(FileAction.Read, FileAction.Write, FileAction.Delete);
    }
}

