/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.modifier;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.modifier.PropertyModifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.security.action.GetPropertyAction;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ForkJoinPoolPropertyModifier
implements PropertyModifier {
    private static final Logger logger = SecurityLogManager.getLogger(ForkJoinPoolPropertyModifier.class);
    private static final String THREAD_FACTORY_NAME = "java.util.concurrent.ForkJoinPool.common.threadFactory";
    private static final String FORK_JOIN_POOL_DEFAULT_FACTORY_NAME = "java.util.concurrent.ForkJoinPool$DefaultForkJoinWorkerThreadFactory";

    @Override
    public void modifyProperty() {
        logger.info("Set {} = {}", (Object)THREAD_FACTORY_NAME, (Object)FORK_JOIN_POOL_DEFAULT_FACTORY_NAME);
        String factory = AccessController.doPrivileged(new GetPropertyAction(THREAD_FACTORY_NAME));
        if (factory == null) {
            AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.setProperty(ForkJoinPoolPropertyModifier.THREAD_FACTORY_NAME, ForkJoinPoolPropertyModifier.FORK_JOIN_POOL_DEFAULT_FACTORY_NAME);
                }
            });
        }
    }
}

