/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass;

import com.aliyun.rapt.commons.circuitbreaker.CircuitBreaker;
import com.aliyun.rapt.commons.circuitbreaker.CircuitBreakerMonitor;
import com.aliyun.rapt.commons.circuitbreaker.breaker.CompositeCircuitBreaker;
import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.RassSecurityManager;
import com.aliyun.securitysdk.rass.api.Permission;
import com.aliyun.securitysdk.rass.api.PermissionChecker;
import com.aliyun.securitysdk.rass.api.RaptSecurityContext;
import com.aliyun.securitysdk.rass.api.RuntimeApplicationSecuritySandbox;
import com.aliyun.securitysdk.rass.api.annotation.Order;
import com.aliyun.securitysdk.rass.api.config.ConfigLoader;
import com.aliyun.securitysdk.rass.api.config.RassConfig;
import com.aliyun.securitysdk.rass.api.interceptor.CheckInterceptor;
import com.aliyun.securitysdk.rass.api.spi.RassLifestyleListener;
import com.aliyun.securitysdk.rass.config.schema.RassPolicy;
import com.aliyun.securitysdk.rass.config.schema.Serialization;
import com.aliyun.securitysdk.rass.context.RassRuntimeContext;
import com.aliyun.securitysdk.rass.filter.ObjectInputFilterRegister;
import com.aliyun.securitysdk.rass.filter.RassObjectFilter;
import com.aliyun.securitysdk.rass.interceptor.CircuitBreakerInterceptorAdaptor;
import com.aliyun.securitysdk.rass.interceptor.SimpleCircuitBreakerInterceptor;
import com.aliyun.securitysdk.rass.modifier.PropertyModifiers;
import com.aliyun.securitysdk.rass.net.NetHooksProviderRegister;
import com.aliyun.securitysdk.rass.permission.CmdPermission;
import com.aliyun.securitysdk.rass.permission.FilePermission;
import com.aliyun.securitysdk.rass.permission.SerializationPermission;
import com.aliyun.securitysdk.rass.permission.SocketPermission;
import com.aliyun.securitysdk.rass.resource.DynamicResourceManager;
import com.aliyun.securitysdk.rass.resource.ResourceReloadListener;
import com.aliyun.securitysdk.rass.spi.ServiceProvider;
import com.aliyun.securitysdk.rass.util.ClassUtils;
import com.aliyun.securitysdk.rass.util.LogVersionUtil;
import com.aliyun.securitysdk.rass.util.ObjectUtils;
import com.aliyun.securitysdk.rass.util.WebApplicationType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;

@Order(value=10)
public class RuntimeApplicationSecuritySandboxImpl
implements RuntimeApplicationSecuritySandbox {
    private static final Logger logger = SecurityLogManager.getLogger(RuntimeApplicationSecuritySandboxImpl.class);
    private final AtomicReference<RuntimeApplicationSecuritySandbox.Status> status = new AtomicReference();
    private RassConfig rassConfig;
    private CircuitBreakerMonitor circuitBreakerMonitor;
    private volatile RaptSecurityContext raptSecurityContext;
    private final ServiceProvider serviceProvider;
    private RassObjectFilter rassObjectFilter;
    private final List<RassLifestyleListener> rassLifestyleListeners;
    private final RassRuntimeContext rassRuntimeContext = RassRuntimeContext.INSTANCE;
    private SimpleCircuitBreakerInterceptor globalCheckInterceptor;
    private final RassSecurityManager rassSecurityManager;

    public RuntimeApplicationSecuritySandboxImpl() {
        this.serviceProvider = new ServiceProvider();
        this.rassSecurityManager = new RassSecurityManager(this);
        this.rassLifestyleListeners = this.serviceProvider.lifestyleListenerList();
        for (RassLifestyleListener rassLifestyleListener : this.rassLifestyleListeners) {
            rassLifestyleListener.setRuntimeApplicationSecuritySandbox((RuntimeApplicationSecuritySandbox)this);
        }
    }

    public RuntimeApplicationSecuritySandboxImpl(RassConfig rassConfig) {
        DynamicResourceManager.setRassConfig(rassConfig);
        this.serviceProvider = new ServiceProvider();
        this.rassSecurityManager = new RassSecurityManager(this);
        this.rassLifestyleListeners = this.serviceProvider.lifestyleListenerList();
        for (RassLifestyleListener rassLifestyleListener : this.rassLifestyleListeners) {
            rassLifestyleListener.setRuntimeApplicationSecuritySandbox((RuntimeApplicationSecuritySandbox)this);
        }
    }

    public void initialize() {
        if (!this.status.weakCompareAndSet(null, RuntimeApplicationSecuritySandbox.Status.Initializing)) {
            return;
        }
        SecurityManager previousSecurityManager = System.getSecurityManager();
        if (previousSecurityManager != null && previousSecurityManager.getClass().getCanonicalName().equals(RassSecurityManager.class.getCanonicalName())) {
            logger.warn("RASS has been loaded and initialized by another classloader");
            return;
        }
        if (this.rassConfig == null) {
            this.rassConfig = ConfigLoader.loadSecurityConfig();
        }
        if (LogVersionUtil.IS_LOG4J2_PRESENTS && LogVersionUtil.IS_LOG4J2_CORE_PRESENTS && WebApplicationType.CURRENT_TYPE == WebApplicationType.NONE) {
            PropertyModifiers.modifyLog4j2LookupProperties();
            if (!this.rassConfig.isIgnoreLog4jWarning()) {
                logger.warn("Your non-web project, that contains log4j2 component, is vulnerable with log shell attack.This warning can safely be ignored util your security officer confirmed.");
            }
        }
        PropertyModifiers.modifyProperties();
        this.raptSecurityContext = new RaptSecurityContext((RuntimeApplicationSecuritySandbox)this);
        this.circuitBreakerMonitor = CircuitBreakerMonitor.getInstance();
        logger.info("Starting circuit breaker...");
        DynamicResourceManager resourceManager = DynamicResourceManager.getInstance();
        resourceManager.registerResourceReloadListener(new ResourceReloadListener(){

            @Override
            public void onReload() {
                RuntimeApplicationSecuritySandboxImpl.this.reload();
            }
        });
        this.registerPolicy(this.raptSecurityContext, resourceManager);
        this.configPolicy(this.raptSecurityContext, resourceManager);
        for (RassLifestyleListener rassLifestyleListener : this.rassLifestyleListeners) {
            rassLifestyleListener.onInitialize();
        }
        logger.info("Registering socket hooks...");
        NetHooksProviderRegister.registerNetHooksProvider();
        logger.info("Registering object filters...");
        if (ClassUtils.isObjectInputFilterClassPresent()) {
            this.rassObjectFilter = ObjectInputFilterRegister.registerEnhancedObjectInputFilter(this.raptSecurityContext);
        }
        System.setSecurityManager(this.rassSecurityManager);
        logger.info("Initialization finished!");
        this.status.set(RuntimeApplicationSecuritySandbox.Status.Working);
    }

    private void registerChecker(RaptSecurityContext raptSecurityContext, List<? extends PermissionChecker<?>> permissionCheckers, Class<? extends Permission> permissionType) {
        if (!ObjectUtils.allNotNull(raptSecurityContext, permissionCheckers, permissionType) || permissionCheckers.isEmpty()) {
            return;
        }
        logger.info("Registering {} checker for permission {}", (Object)permissionCheckers.size(), (Object)permissionType.getName());
        for (PermissionChecker<?> permissionChecker : permissionCheckers) {
            raptSecurityContext.registerTypedPermissionCheck(permissionChecker, permissionType);
        }
    }

    private void registerInterceptor(RaptSecurityContext raptSecurityContext) {
        CompositeCircuitBreaker circuitBreaker = this.circuitBreakerMonitor.getCircuitBreaker("rapt_fusing_rass.xml");
        this.globalCheckInterceptor = new SimpleCircuitBreakerInterceptor();
        raptSecurityContext.registerGlobalCheckInterceptor((CheckInterceptor)this.globalCheckInterceptor);
        raptSecurityContext.registerGlobalCheckInterceptor((CheckInterceptor)new CircuitBreakerInterceptorAdaptor((CircuitBreaker<?>)circuitBreaker));
    }

    public void terminate() {
        logger.info("Terminating security sandbox...");
        this.globalCheckInterceptor.force2Reset(false);
        if (System.getSecurityManager() != null && System.getSecurityManager().equals(this.rassSecurityManager)) {
            Class<System> systemClass = System.class;
            try {
                Method getFields = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                getFields.setAccessible(true);
                Field[] fields = (Field[])getFields.invoke(systemClass, false);
                Field securityField = null;
                for (Field field : fields) {
                    if (!field.getName().equals("security")) continue;
                    securityField = field;
                    break;
                }
                assert (securityField != null);
                securityField.setAccessible(true);
                securityField.set(null, this.rassSecurityManager.getDelegate());
            }
            catch (AssertionError | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.warn("reset security manager failed", (Throwable)e);
            }
        }
        this.status.set(RuntimeApplicationSecuritySandbox.Status.Terminated);
        for (RassLifestyleListener rassLifestyleListener : this.rassLifestyleListeners) {
            rassLifestyleListener.onTerminate();
        }
        logger.info("Security sandbox is terminated.");
    }

    public void resume() {
        logger.info("Resuming security sandbox...");
        if (this.status.compareAndSet(RuntimeApplicationSecuritySandbox.Status.Terminated, RuntimeApplicationSecuritySandbox.Status.Working)) {
            if (this.globalCheckInterceptor.checkAndChangeState(true)) {
                if (this.rassSecurityManager != null && !this.rassSecurityManager.equals(System.getSecurityManager())) {
                    System.setSecurityManager(this.rassSecurityManager);
                }
                for (RassLifestyleListener rassLifestyleListener : this.rassLifestyleListeners) {
                    rassLifestyleListener.onResume();
                }
                logger.info("Security sandbox is now working.");
            }
            logger.info("Failed to resume security sandbox since the status isn't 'terminated'.");
        }
    }

    public void destroy() {
        try {
            this.globalCheckInterceptor.force2Reset(false);
            for (RassLifestyleListener rassLifestyleListener : this.rassLifestyleListeners) {
                rassLifestyleListener.onDestroy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RuntimeApplicationSecuritySandbox.Status getStatus() {
        return this.status.get();
    }

    public void reload() {
        logger.info("Reloading...");
        if (!this.status.compareAndSet(RuntimeApplicationSecuritySandbox.Status.Working, RuntimeApplicationSecuritySandbox.Status.Reloading)) {
            return;
        }
        DynamicResourceManager resourceManager = DynamicResourceManager.getInstance();
        RaptSecurityContext raptSecurityContext = new RaptSecurityContext((RuntimeApplicationSecuritySandbox)this);
        this.registerPolicy(raptSecurityContext, resourceManager);
        this.configPolicy(raptSecurityContext, resourceManager);
        this.raptSecurityContext = raptSecurityContext;
        this.rassObjectFilter.resetRaptSecurityContext(raptSecurityContext);
        if (this.status.compareAndSet(RuntimeApplicationSecuritySandbox.Status.Reloading, RuntimeApplicationSecuritySandbox.Status.Working)) {
            logger.info("Finish reloading");
            for (RassLifestyleListener rassLifestyleListener : this.rassLifestyleListeners) {
                rassLifestyleListener.onReload();
            }
        } else {
            logger.warn("Failed to reload, the status is not reloading now.");
        }
    }

    private void configPolicy(RaptSecurityContext raptSecurityContext, DynamicResourceManager resourceManager) {
        logger.info("Registering interceptors...");
        this.registerInterceptor(raptSecurityContext);
        RassPolicy rassPolicy = resourceManager.getRassPolicy();
        this.rassRuntimeContext.setCurrentReadableVersion(rassPolicy.getVersion());
        raptSecurityContext.setCurrentVersion(UUID.nameUUIDFromBytes(rassPolicy.getVersion().getBytes()));
        this.rassRuntimeContext.setRaptSecurityContext(raptSecurityContext);
    }

    private void registerPolicy(RaptSecurityContext raptSecurityContext, DynamicResourceManager resourceManager) {
        logger.info("registering policy...");
        this.registerChecker(raptSecurityContext, resourceManager.getCmdPermissionCheckers(), CmdPermission.class);
        this.registerChecker(raptSecurityContext, resourceManager.getFilePermissionCheckers(), FilePermission.class);
        this.registerChecker(raptSecurityContext, resourceManager.getSocketPermissionCheckers(), SocketPermission.class);
        this.registerChecker(raptSecurityContext, resourceManager.getSerializationPermissionCheckers(), SerializationPermission.class);
        Serialization serialization = resourceManager.getRassPolicy().getAuthority().getSerialization();
        if (serialization != null && serialization.isFastjsonEnabled()) {
            PropertyModifiers.modifyFastJsonProperties(serialization);
        }
    }

    public RaptSecurityContext getRaptSecurityContext() {
        return this.raptSecurityContext;
    }

    RassConfig getRassConfig() {
        return this.rassConfig;
    }

    public SimpleCircuitBreakerInterceptor getGlobalCheckInterceptor() {
        return this.globalCheckInterceptor;
    }

    public RassSecurityManager getRassSecurityManager() {
        return this.rassSecurityManager;
    }
}

