/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.oozie.convert;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubworkflowNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(SubworkflowNodeConvert.class);

    public SubworkflowNodeConvert(TaskContext taskContext) {
        super(taskContext);
    }

    public SubworkflowNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        WorkflowNode tgtworkflowNode2 = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        tgtworkflowNode.setNodeType(this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.subWorkflowNodeType", CodeProgramType.VIRTUAL.getName()));
        tgtworkflowNode2.setNodeType(this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.subWorkflowNodeType", CodeProgramType.VIRTUAL.getName()));
        tgtNodes.add(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode2);
        String appPath = (String)tgtworkflowNode.getCustomProperties().get("appPath");
        String[] temp = appPath.split("/");
        appPath = temp[temp.length - 1];
        for (Workflow wf : this.taskContext.getWorkflowProjectPackage().getWorkflowList()) {
            if (!appPath.equals(wf.getDatasourceId())) continue;
            appPath = wf.getWorkflowName();
            break;
        }
        tgtworkflowNode.setNodeName(tgtworkflowNode.getNodeName() + "_1");
        tgtworkflowNode.setNodeId(tgtworkflowNode.getNodeId() + "_1");
        this.workflow.getNodeRelations().add(new RelationPackage(tgtworkflowNode.getNodeId(), appPath + "_START", RelationPackage.ReType.NODE));
        tgtworkflowNode2.setNodeName(tgtworkflowNode2.getNodeName() + "_2");
        tgtworkflowNode2.setNodeId(tgtworkflowNode2.getNodeId() + "_2");
        this.workflow.getNodeRelations().add(new RelationPackage(appPath + "_END", tgtworkflowNode2.getNodeId(), RelationPackage.ReType.NODE));
        return tgtNodes;
    }
}

