/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.oozie.convert;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(DecisionNodeConvert.class);

    public DecisionNodeConvert(TaskContext taskContext) {
        super(taskContext);
    }

    public DecisionNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        tgtworkflowNode.setNodeType(this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.decisionNodeType", CodeProgramType.CONTROLLER_BRANCH.getName()));
        String switchCaseString = workflowNode.getCustomProperties().get("condition").toString();
        StringBuilder switchCaseScript = new StringBuilder();
        switchCaseScript.append("<![CDATA[[");
        for (String singleSwitchCase : switchCaseString.split("\n")) {
            String[] conditionAndTarget = singleSwitchCase.split("\t");
            String condition = conditionAndTarget[0];
            String target = conditionAndTarget[1];
            String relationName = workflowNode.getNodeName() + "_to_" + target;
            switchCaseScript.append("{\\&quot;condition\\&quot;:\\&quot;");
            switchCaseScript.append(condition);
            switchCaseScript.append("\\&quot;,\\&quot;nodeoutput\\&quot;:\\&quot;");
            switchCaseScript.append(relationName);
            switchCaseScript.append("\\&quot;,\\&quot;description\\&quot;:\\&quot;");
            switchCaseScript.append("\\&quot;},");
        }
        switchCaseScript.deleteCharAt(switchCaseScript.length() - 1);
        switchCaseScript.append("]]]>");
        tgtworkflowNode.setScript(switchCaseScript.toString());
        return List.of(tgtworkflowNode);
    }
}

