/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.openapi.tool;

import com.aliyun.dataworks_public20200518.models.ListBusinessResponseBody;
import com.aliyun.dataworks_public20200518.models.ListFilesRequest;
import com.aliyun.dataworks_public20200518.models.ListFilesResponseBody;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.utils.CustomCreateFileRequest;
import com.aliyun.migration.workflow.migration.common.utils.CustomCreateFileResponse;
import com.aliyun.migration.workflow.migration.common.utils.DwClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwTaskTool {
    private static final Logger log = LoggerFactory.getLogger(DwTaskTool.class);
    private DwClient dwClient;

    public DwTaskTool(Map<String, String> properties) {
        String endpoint = properties.get("endpoint");
        String ak = properties.get("ak");
        String sk = properties.get("sk");
        String oss = properties.get("oss-path");
        this.dwClient = oss == null ? new DwClient(endpoint, ak, sk) : new DwClient(endpoint, ak, sk, oss);
    }

    public DwTaskTool(String endpoint, String accessKeyId, String accessKeySecret) {
        this.dwClient = new DwClient(endpoint, accessKeyId, accessKeySecret);
    }

    public DwTaskTool(String endpoint, String accessKeyId, String accessKeySecret, String ossPath) {
        this.dwClient = new DwClient(endpoint, accessKeyId, accessKeySecret, ossPath);
    }

    public DwClient getDwClient() {
        return this.dwClient;
    }

    public CustomCreateFileResponse sendRequest(CustomCreateFileRequest request) throws Exception {
        CustomCreateFileResponse response = this.dwClient.createFileTemplate(request);
        return response;
    }

    public void submitTask(long projectId, long fieldId) throws Exception {
        this.dwClient.submitFile(Long.valueOf(projectId), fieldId, true);
    }

    public ListBusinessResponseBody.ListBusinessResponseBodyDataBusiness getExistedBusiness(Workflow workflow) {
        List business = this.dwClient.searchBusiness(Long.valueOf(Long.parseLong(workflow.getProjectId())), workflow.getWorkflowName());
        return ((List)Optional.ofNullable(business).orElse(new ArrayList())).stream().filter(b -> b.businessName.equals(workflow.getWorkflowName())).findFirst().orElse(null);
    }

    public ListFilesResponseBody.ListFilesResponseBodyDataFiles getExistedWorkflowNode(WorkflowNode workflowNode) {
        ListFilesResponseBody.ListFilesResponseBodyDataFiles dataFiles = null;
        ListFilesRequest listFilesRequest = new ListFilesRequest();
        listFilesRequest.setKeyword(workflowNode.getNodeName());
        listFilesRequest.setProjectId(Long.valueOf(Long.parseLong(workflowNode.getProjectId())));
        listFilesRequest.setNeedContent(Boolean.valueOf(true));
        List listFilesResponseBodyDataFiles = null;
        try {
            listFilesResponseBodyDataFiles = this.dwClient.listFiles(listFilesRequest);
        }
        catch (InterruptedException e) {
            log.error("get.workflownode.eror {}", (Object)workflowNode.getNodeName(), (Object)e);
        }
        if (CollectionUtils.isNotEmpty((Collection)listFilesResponseBodyDataFiles)) {
            dataFiles = listFilesResponseBodyDataFiles.stream().filter(x -> x.fileName.equals(workflowNode.getNodeName())).findFirst().orElse(null);
        }
        return dataFiles;
    }

    public Long getRequestTimesCount() {
        return this.dwClient.getRequestTimesCount();
    }
}

