/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.openapi.converter;

import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.utils.CustomCreateFileRequest;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.AbstractDwNodeConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.DefaultConverter;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLConverter
extends AbstractDwNodeConverter {
    private static final Logger log = LoggerFactory.getLogger(SQLConverter.class);
    private static final String DEFAULT_PATH = "\u4e1a\u52a1\u6d41\u7a0b/%s/\u6570\u636e\u5e93";

    @Override
    public CustomCreateFileRequest convert(WorkflowNode workflowNode) {
        String projectName = workflowNode.getProjectName();
        DefaultConverter defaultConverter = new DefaultConverter(this.taskContextConf);
        CustomCreateFileRequest customCreateFileRequest = defaultConverter.convert(workflowNode);
        customCreateFileRequest.setFileFolderPath(String.format(DEFAULT_PATH, workflowNode.getWorkflowName()));
        customCreateFileRequest.setFileType(Integer.valueOf(this.getDbType(workflowNode.getDbType())));
        String prefixPath = workflowNode.getScriptPathPreFix();
        customCreateFileRequest.setPrefixPath(prefixPath);
        if (Objects.nonNull(this.taskContextConf)) {
            Boolean autoParse = this.taskContextConf.getBool("autoParse", Boolean.FALSE.booleanValue());
            customCreateFileRequest.setAutoParsing(autoParse);
        }
        customCreateFileRequest.setProjectId(Long.valueOf(Long.parseLong(workflowNode.getProjectId())));
        workflowNode.setScriptPath(StringUtils.trim((String)workflowNode.getScriptPath()));
        customCreateFileRequest.setFileName(workflowNode.getNodeName());
        if (StringUtils.isNotBlank((String)workflowNode.getScriptPath())) {
            try {
                String scriptContent = FileUtils.readFileToString((File)new File(this.getLocalScriptFilePath(customCreateFileRequest.getPrefixPath(), workflowNode.getScriptPath())));
                workflowNode.setScript(scriptContent);
            }
            catch (Exception e) {
                log.error("\u5f53\u524dsql\u8282\u70b9\u8bfb\u53d6\u811a\u672c\u5185\u5bb9\u5931\u8d25\uff1a{}", (Object)workflowNode.getScriptPath());
                log.error("\u8282\u70b9\u521b\u5efa\u5931\u8d25\uff1a{}", (Object)workflowNode.getNodeName());
                workflowNode.setScript("select 1");
            }
        }
        customCreateFileRequest.setContent(workflowNode.getScript());
        this.setInputList(workflowNode.getProjectName(), workflowNode, customCreateFileRequest);
        return customCreateFileRequest;
    }

    private String getLocalScriptFilePath(String rooDir, String scriptPath) {
        return new File(new File(rooDir), scriptPath).getPath();
    }

    private int getDbType(String type) {
        try {
            DBType resDbType = Arrays.stream(DBType.values()).filter(dbType -> dbType.name().equalsIgnoreCase(type)).findAny().orElse(DBType.MySQL);
            return resDbType.getCode();
        }
        catch (Exception e) {
            log.error("getdbtype error ", (Throwable)e);
            return DBType.MySQL.getCode();
        }
    }

    static enum DBType {
        MySQL(1000039),
        SQLServer(10001),
        Oracle(10002),
        POSTGRESQL(10003),
        DRDS(10005),
        PolarDBMySQL(10006),
        PolarDBPostgreSQL(10007),
        Doris(10008),
        MariaDB(10009),
        SelectDB(10010),
        Redshift(10011),
        SAPHANA(10012),
        Vertica(10013),
        DM(10014),
        KingbaseES(10015),
        OceanBase(10016),
        DB2(10017),
        GBase(10018);

        private int code;

        private DBType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

