/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.openapi.converter;

import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.utils.CustomCreateFileRequest;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.AbstractDwNodeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdpsFunctionConverter
extends AbstractDwNodeConverter {
    private static final Logger log = LoggerFactory.getLogger(OdpsFunctionConverter.class);
    private static final String EMR_FILE_FOLDER_FORMAT = "\u4e1a\u52a1\u6d41\u7a0b/%s/MaxCompute";

    @Override
    public CustomCreateFileRequest convert(WorkflowNode workflowNode) {
        WorkflowFunctionResource workflowFunctionResource = (WorkflowFunctionResource)workflowNode.getFunctions().get(0);
        CustomCreateFileRequest request = this.convert(workflowFunctionResource, workflowNode.getWorkflowName());
        return request;
    }

    public CustomCreateFileRequest convert(WorkflowFunctionResource functionResource, String workflowName) {
        CustomCreateFileRequest request = new CustomCreateFileRequest();
        request.setActionName("CreateUdfFile");
        request.setFileFolderPath(String.format(EMR_FILE_FOLDER_FORMAT, workflowName));
        request.setProjectId(Long.valueOf(Long.parseLong(functionResource.getProjectId())));
        request.setFileName(functionResource.getName());
        request.setFunctionType(functionResource.getFunctionType().name());
        request.setClassName(functionResource.getClassName());
        request.setResources(functionResource.getFileResources());
        request.setUdfDescription(functionResource.getUsageDescription());
        request.setCmdDescription(functionResource.getArgumentsDescription());
        request.setParameterDescription(functionResource.getArgumentsDescription());
        request.setReturnValue(null);
        request.setExample(null);
        request.setProjectIdentifier(functionResource.getProjectId());
        request.setCreateFolderIfNotExists(Boolean.valueOf(false));
        return request;
    }
}

