/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.openapi.converter;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.utils.CustomCreateFileRequest;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.AbstractDwNodeConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMRFileConverter
extends AbstractDwNodeConverter {
    private static final Logger log = LoggerFactory.getLogger(EMRFileConverter.class);
    private static final String EMR_FILE_FOLDER_FORMAT = "\u4e1a\u52a1\u6d41\u7a0b/%s/EMR";

    @Override
    public CustomCreateFileRequest convert(WorkflowNode workflowNode) {
        WorkflowFileResource workflowFileResource = (WorkflowFileResource)workflowNode.getFiles().get(0);
        CustomCreateFileRequest request = this.convert(workflowFileResource, workflowNode.getWorkflowName());
        return request;
    }

    public CustomCreateFileRequest convert(WorkflowFileResource fileResource, String workflowName) {
        CustomCreateFileRequest request = new CustomCreateFileRequest();
        request.setActionName("CreateResourceFile");
        request.setProjectId(Long.valueOf(Long.parseLong(fileResource.getProjectId())));
        request.setFileFolderPath(String.format(EMR_FILE_FOLDER_FORMAT, workflowName));
        request.setFileName(fileResource.getName());
        request.setFileType(Integer.valueOf(CodeProgramType.EMR_FILE.getCode()));
        request.setFileDescription(fileResource.getDescription());
        request.setOwner(null);
        request.setContent(null);
        try {
            if (!new File(fileResource.getPath()).exists()) {
                log.error("\u6587\u4ef6\u4e22\u5931\uff0cpath:{}\uff0cname:{}", (Object)fileResource.getPath(), (Object)fileResource.getName());
                throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.FILE_NOT_FOUND, (String)"fileresource.not.found");
            }
            request.setResourceFileObject((InputStream)new FileInputStream(fileResource.getPath()));
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e22\u5931\uff0cpath:{}\uff0cname:{}", (Object)fileResource.getPath(), (Object)fileResource.getName());
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.FILE_NOT_FOUND, (String)"fileresource.not.found");
        }
        request.setOriginResourceName(fileResource.getName());
        request.setRegisterToCalcEngine(Boolean.valueOf(false));
        request.setStorageURL("");
        return request;
    }
}

