/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.openapi.converter;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.ADBPGConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.AbstractDwNodeConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.ControllerBranchConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.ControllerJoinConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.DIConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.DefaultConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.EMRFileConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.EMRFunctionConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.EMRJarConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.EMRwithSHScriptConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.EMRwithSQLScriptConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.HoloGresSqlConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.ODPSMRConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.OdpsFunctionConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.OdpsPythonConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.OdpsSqlConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.SQLConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.ShellConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.VIConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwConverterFactory {
    private static final Logger log = LoggerFactory.getLogger(DwConverterFactory.class);
    private static Map<CodeProgramType, AbstractDwNodeConverter> CONVERTMAP = new HashMap<CodeProgramType, AbstractDwNodeConverter>();

    public static AbstractDwNodeConverter buildConvert(String type, BwmConfiguration bwmConfiguration) {
        if (StringUtils.isBlank((String)type)) {
            log.error("type is null {}", (Object)type);
            return new DefaultConverter();
        }
        CodeProgramType resType = null;
        for (CodeProgramType nodeType : CodeProgramType.values()) {
            if (!(type.equals(String.valueOf(nodeType.getCode())) | type.equals(String.valueOf(nodeType.getName())))) continue;
            resType = nodeType;
            break;
        }
        if (Objects.isNull(resType)) {
            log.info("type not supported: {}", (Object)type);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.BWM_TYPE_NOT_SUPPORTED_ERROR);
        }
        AbstractDwNodeConverter converter = CONVERTMAP.getOrDefault(resType, new DefaultConverter());
        converter.setConf(bwmConfiguration);
        return converter;
    }

    static {
        CONVERTMAP.put(CodeProgramType.VIRTUAL, new VIConverter());
        CONVERTMAP.put(CodeProgramType.ODPS_SQL, new OdpsSqlConverter());
        CONVERTMAP.put(CodeProgramType.ODPS_FUNCTION, new OdpsFunctionConverter());
        CONVERTMAP.put(CodeProgramType.DI, new DIConverter());
        CONVERTMAP.put(CodeProgramType.SHELL, new ShellConverter());
        CONVERTMAP.put(CodeProgramType.DIDE_SHELL, new ShellConverter());
        CONVERTMAP.put(CodeProgramType.CONTROLLER_BRANCH, new ControllerBranchConverter());
        CONVERTMAP.put(CodeProgramType.CONTROLLER_JOIN, new ControllerJoinConverter());
        CONVERTMAP.put(CodeProgramType.SQL_COMPONENT, new OdpsSqlConverter());
        CONVERTMAP.put(CodeProgramType.ODPS_MR, new ODPSMRConverter());
        CONVERTMAP.put(CodeProgramType.ODPS_SPARK, new ODPSMRConverter());
        CONVERTMAP.put(CodeProgramType.ODPS_PYTHON, new OdpsPythonConverter());
        CONVERTMAP.put(CodeProgramType.ODPS_SPARK_SQL, new OdpsSqlConverter());
        CONVERTMAP.put(CodeProgramType.ODPS_SCRIPT, new OdpsSqlConverter());
        CONVERTMAP.put(CodeProgramType.PYODPS, new OdpsSqlConverter());
        CONVERTMAP.put(CodeProgramType.PYODPS3, new OdpsSqlConverter());
        CONVERTMAP.put(CodeProgramType.EMR_HIVE, new EMRwithSQLScriptConverter());
        CONVERTMAP.put(CodeProgramType.EMR_SPARK, new EMRwithSHScriptConverter());
        CONVERTMAP.put(CodeProgramType.EMR_SPARK_SQL, new EMRwithSQLScriptConverter());
        CONVERTMAP.put(CodeProgramType.EMR_MR, new EMRwithSHScriptConverter());
        CONVERTMAP.put(CodeProgramType.EMR_SHELL, new EMRwithSHScriptConverter());
        CONVERTMAP.put(CodeProgramType.EMR_PRESTO, new EMRwithSQLScriptConverter());
        CONVERTMAP.put(CodeProgramType.EMR_IMPALA, new EMRwithSQLScriptConverter());
        CONVERTMAP.put(CodeProgramType.EMR_SPARK_STREAMING, new EMRwithSHScriptConverter());
        CONVERTMAP.put(CodeProgramType.EMR_TRINO, new EMRwithSQLScriptConverter());
        CONVERTMAP.put(CodeProgramType.EMR_JAR, new EMRJarConverter());
        CONVERTMAP.put(CodeProgramType.EMR_FILE, new EMRFileConverter());
        CONVERTMAP.put(CodeProgramType.EMR_FUNCTION, new EMRFunctionConverter());
        CONVERTMAP.put(CodeProgramType.HOLOGRES_SQL, new HoloGresSqlConverter());
        CONVERTMAP.put(CodeProgramType.POSTGRESQL, new SQLConverter());
        CONVERTMAP.put(CodeProgramType.MYSQL, new SQLConverter());
        CONVERTMAP.put(CodeProgramType.SQLSERVER, new SQLConverter());
        CONVERTMAP.put(CodeProgramType.Oracle, new SQLConverter());
        CONVERTMAP.put(CodeProgramType.StarRocks, new SQLConverter());
        CONVERTMAP.put(CodeProgramType.DRDS, new SQLConverter());
        CONVERTMAP.put(CodeProgramType.Doris, new SQLConverter());
        CONVERTMAP.put(CodeProgramType.Mariadb, new SQLConverter());
        CONVERTMAP.put(CodeProgramType.Selectdb, new SQLConverter());
        CONVERTMAP.put(CodeProgramType.Redshift, new SQLConverter());
        CONVERTMAP.put(CodeProgramType.Saphana, new SQLConverter());
        CONVERTMAP.put(CodeProgramType.Vertica, new SQLConverter());
        CONVERTMAP.put(CodeProgramType.OceanBase, new SQLConverter());
        CONVERTMAP.put(CodeProgramType.DB2, new SQLConverter());
        CONVERTMAP.put(CodeProgramType.ADB_for_PostgreSQL, new ADBPGConverter());
    }
}

