/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.newide.tools;

import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.spec.domain.dataworks.node.DataWorksNodeTypeUtils;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWorksTopologicalUtils {
    private static final Logger log = LoggerFactory.getLogger(DataWorksTopologicalUtils.class);

    public static void sortWorkflowByDependency4DataWorksId(WorkflowProjectPackage workflowProjectPackage, DataWorksNodeTypeUtils dataWorksNodeTypeUtils, List<String> sortWorkflowIdList, Map<String, Set<String>> downstreamDependencies) {
        String dataworksWorkflowId;
        HashMap<String, String> nodeWorkflowMap = new HashMap<String, String>();
        if (workflowProjectPackage.getWorkflowList() != null) {
            for (Object workflow : workflowProjectPackage.getWorkflowList()) {
                String dataworksWorkflowId2 = StringUtils.isEmpty((String)workflow.getTWorkflowId()) ? workflow.getWorkflowId() : workflow.getTWorkflowId();
                nodeWorkflowMap.put(workflow.getWorkflowId(), dataworksWorkflowId2);
                if (workflow.getWorkflowNodes() == null) continue;
                for (WorkflowNode node : workflow.getWorkflowNodes()) {
                    nodeWorkflowMap.put(node.getNodeId(), dataworksWorkflowId2);
                }
            }
        }
        HashMap<String, List<String>> workflowDependencyMap = new HashMap<String, List<String>>();
        if (workflowProjectPackage.getWorkflowList() != null) {
            for (Object workflow : workflowProjectPackage.getWorkflowList()) {
                String string = dataworksWorkflowId = StringUtils.isEmpty((String)workflow.getTWorkflowId()) ? workflow.getWorkflowId() : workflow.getTWorkflowId();
                if (!workflowDependencyMap.containsKey(dataworksWorkflowId)) {
                    workflowDependencyMap.put(dataworksWorkflowId, new ArrayList());
                }
                if (workflow.getNodeRelations() == null) continue;
                for (RelationPackage relation : workflow.getNodeRelations()) {
                    String toWorkflow;
                    String fromWorkflow;
                    String from = relation.getFrom();
                    String to = relation.getTo();
                    if (!nodeWorkflowMap.containsKey(from) || !nodeWorkflowMap.containsKey(to) || StringUtils.equals((String)(fromWorkflow = (String)nodeWorkflowMap.get(from)), (String)(toWorkflow = (String)nodeWorkflowMap.get(to)))) continue;
                    if (!workflowDependencyMap.containsKey(fromWorkflow)) {
                        workflowDependencyMap.put(fromWorkflow, new ArrayList());
                    }
                    if (((List)workflowDependencyMap.get(fromWorkflow)).contains(toWorkflow)) continue;
                    ((List)workflowDependencyMap.get(fromWorkflow)).add(toWorkflow);
                }
            }
        }
        if (workflowProjectPackage.getWorkflowList() != null) {
            for (Object workflow : workflowProjectPackage.getWorkflowList()) {
                String string = dataworksWorkflowId = StringUtils.isEmpty((String)workflow.getTWorkflowId()) ? workflow.getWorkflowId() : workflow.getTWorkflowId();
                if (workflow.getWorkflowNodes() == null) continue;
                for (Object node : workflow.getWorkflowNodes()) {
                    if (!Objects.equals(dataWorksNodeTypeUtils.getNodeType(node.getNodeType()), DataWorksNodeTypeUtils.CustomCodeProgramType.SUB_PROCESS)) continue;
                    String fromWorkflow = node.getScript();
                    if (nodeWorkflowMap.containsKey(fromWorkflow)) {
                        fromWorkflow = (String)nodeWorkflowMap.get(fromWorkflow);
                    }
                    String toWorkflow = dataworksWorkflowId;
                    if (workflowDependencyMap.containsKey(fromWorkflow)) {
                        if (((List)workflowDependencyMap.get(fromWorkflow)).contains(toWorkflow)) continue;
                        ((List)workflowDependencyMap.get(fromWorkflow)).add(toWorkflow);
                        continue;
                    }
                    log.warn("Subprocess\u8282\u70b9{}\u8bb0\u5f55\u4e86\u5bf9workflow{}\u7684\u5f15\u7528\uff0c\u4f46workflow{}\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", new Object[]{node.getNodeName(), fromWorkflow, fromWorkflow});
                }
            }
        }
        sortWorkflowIdList.addAll(DataWorksTopologicalUtils.topologicalSort(workflowDependencyMap));
        if (sortWorkflowIdList.size() != workflowDependencyMap.size()) {
            HashMap<String, CallSite> workflowIdPathMap = new HashMap<String, CallSite>();
            for (Workflow workflow : workflowProjectPackage.getWorkflowList()) {
                workflowIdPathMap.put(workflow.getWorkflowId(), (CallSite)((Object)((String)(!StringUtils.isEmpty((String)workflow.getCategoryValue()) ? workflow.getCategoryValue() + "/" : "") + workflow.getWorkflowName())));
            }
            ArrayList<String> normalNodesName = new ArrayList<String>();
            ArrayList<String> cycleNodesName = new ArrayList<String>();
            for (Object node : workflowDependencyMap.keySet()) {
                if (!sortWorkflowIdList.contains(node)) {
                    cycleNodesName.add((String)workflowIdPathMap.get(node));
                    continue;
                }
                normalNodesName.add((String)workflowIdPathMap.get(node));
            }
            log.warn("\u65e0\u73af\u6b63\u5e38\u5217\u8868\uff08\u5de5\u5177\u6b63\u5e38\u53d1\u5e03\uff09\u5171\u8ba1{}\u4e2a\uff1a{}", (Object)normalNodesName.size(), normalNodesName);
            log.warn("\u6709\u73af\u5f02\u5e38\u5217\u8868\uff08\u5de5\u5177\u8df3\u8fc7\u53d1\u5e03\uff09\u5171\u8ba1{}\u4e2a\uff1a{}", (Object)cycleNodesName.size(), cycleNodesName);
        }
        downstreamDependencies.putAll(DataWorksTopologicalUtils.findAllDownstreamWorkflow(workflowDependencyMap));
    }

    public static void sortWorkflowByDependency4OrginalId(WorkflowProjectPackage workflowProjectPackage, DataWorksNodeTypeUtils dataWorksNodeTypeUtils, List<String> sortWorkflowIdList, Map<String, Set<String>> downstreamDependencies) {
        HashMap<String, String> nodeWorkflowMap = new HashMap<String, String>();
        if (workflowProjectPackage.getWorkflowList() != null) {
            for (Object workflow : workflowProjectPackage.getWorkflowList()) {
                if (workflow.getIsBusiness() != null && workflow.getIsBusiness().booleanValue()) continue;
                nodeWorkflowMap.put(workflow.getWorkflowId(), workflow.getWorkflowId());
                if (workflow.getWorkflowNodes() == null) continue;
                for (WorkflowNode node : workflow.getWorkflowNodes()) {
                    nodeWorkflowMap.put(node.getNodeId(), workflow.getWorkflowId());
                }
            }
        }
        HashMap<String, List<String>> workflowDependencyMap = new HashMap<String, List<String>>();
        if (workflowProjectPackage.getWorkflowList() != null) {
            for (Object workflow : workflowProjectPackage.getWorkflowList()) {
                if (workflow.getIsBusiness() != null && workflow.getIsBusiness().booleanValue()) continue;
                if (!workflowDependencyMap.containsKey(workflow.getWorkflowId())) {
                    workflowDependencyMap.put(workflow.getWorkflowId(), new ArrayList());
                }
                if (workflow.getNodeRelations() == null) continue;
                for (RelationPackage relation : workflow.getNodeRelations()) {
                    String toWorkflow;
                    String fromWorkflow;
                    String from = relation.getFrom();
                    String to = relation.getTo();
                    if (!nodeWorkflowMap.containsKey(from) || !nodeWorkflowMap.containsKey(to) || StringUtils.equals((String)(fromWorkflow = (String)nodeWorkflowMap.get(from)), (String)(toWorkflow = (String)nodeWorkflowMap.get(to)))) continue;
                    if (!workflowDependencyMap.containsKey(fromWorkflow)) {
                        workflowDependencyMap.put(fromWorkflow, new ArrayList());
                    }
                    if (((List)workflowDependencyMap.get(fromWorkflow)).contains(toWorkflow)) continue;
                    ((List)workflowDependencyMap.get(fromWorkflow)).add(toWorkflow);
                }
            }
        }
        if (workflowProjectPackage.getWorkflowList() != null) {
            for (Object workflow : workflowProjectPackage.getWorkflowList()) {
                if (workflow.getWorkflowNodes() == null) continue;
                for (WorkflowNode node : workflow.getWorkflowNodes()) {
                    if (!Objects.equals(dataWorksNodeTypeUtils.getNodeType(node.getNodeType()), DataWorksNodeTypeUtils.CustomCodeProgramType.SUB_PROCESS)) continue;
                    String fromWorkflow = node.getScript();
                    if (nodeWorkflowMap.containsKey(fromWorkflow)) {
                        fromWorkflow = (String)nodeWorkflowMap.get(fromWorkflow);
                    }
                    String toWorkflow = workflow.getWorkflowId();
                    if (workflowDependencyMap.containsKey(fromWorkflow)) {
                        if (((List)workflowDependencyMap.get(fromWorkflow)).contains(toWorkflow)) continue;
                        ((List)workflowDependencyMap.get(fromWorkflow)).add(toWorkflow);
                        continue;
                    }
                    log.warn("Subprocess\u8282\u70b9{}\u8bb0\u5f55\u4e86\u5bf9workflow{}\u7684\u5f15\u7528\uff0c\u4f46workflow{}\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", new Object[]{node.getNodeName(), fromWorkflow, fromWorkflow});
                }
            }
        }
        sortWorkflowIdList.addAll(DataWorksTopologicalUtils.topologicalSort(workflowDependencyMap));
        if (sortWorkflowIdList.size() != workflowDependencyMap.size()) {
            HashMap<String, CallSite> workflowIdPathMap = new HashMap<String, CallSite>();
            for (Workflow workflow : workflowProjectPackage.getWorkflowList()) {
                workflowIdPathMap.put(workflow.getWorkflowId(), (CallSite)((Object)((String)(!StringUtils.isEmpty((String)workflow.getTWorkflowId()) ? workflow.getCategoryValue() + "/" : "") + workflow.getWorkflowName())));
            }
            ArrayList<String> normalNodesName = new ArrayList<String>();
            ArrayList<String> cycleNodesName = new ArrayList<String>();
            for (String node : workflowDependencyMap.keySet()) {
                if (!sortWorkflowIdList.contains(node)) {
                    cycleNodesName.add((String)workflowIdPathMap.get(node));
                    continue;
                }
                normalNodesName.add((String)workflowIdPathMap.get(node));
            }
            log.warn("\u65e0\u73af\u6b63\u5e38\u5217\u8868\uff08\u5de5\u5177\u6b63\u5e38\u53d1\u5e03\uff09\uff1a{}", normalNodesName);
            log.warn("\u6709\u73af\u5f02\u5e38\u5217\u8868\uff08\u5de5\u5177\u8df3\u8fc7\u53d1\u5e03\uff09\uff1a{}", cycleNodesName);
        }
        downstreamDependencies.putAll(DataWorksTopologicalUtils.findAllDownstreamWorkflow(workflowDependencyMap));
    }

    public static List<String> topologicalSort(Map<String, List<String>> graph) {
        HashMap<String, Integer> indegree = new HashMap<String, Integer>();
        for (List<String> list : graph.values()) {
            for (String node : list) {
                indegree.put(node, indegree.getOrDefault(node, 0) + 1);
            }
        }
        LinkedList<String> queue = new LinkedList<String>();
        for (String node : graph.keySet()) {
            if (indegree.containsKey(node)) continue;
            queue.offer(node);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (!queue.isEmpty()) {
            String node;
            node = (String)queue.poll();
            arrayList.add(node);
            if (!graph.containsKey(node)) continue;
            for (String neighbor : graph.get(node)) {
                indegree.put(neighbor, (Integer)indegree.get(neighbor) - 1);
                if ((Integer)indegree.get(neighbor) != 0) continue;
                queue.offer(neighbor);
            }
        }
        if (arrayList.size() != graph.size()) {
            log.warn("\u4f9d\u8d56\u5173\u7cfb\u5b58\u5728\u73af\uff0c\u8bf7\u68c0\u67e5");
        }
        return arrayList;
    }

    public static Map<String, Set<String>> findAllDownstreamWorkflow(Map<String, List<String>> graph) {
        HashMap<String, Set<String>> allDownstreamNodes = new HashMap<String, Set<String>>();
        for (String node : graph.keySet()) {
            allDownstreamNodes.put(node, new HashSet());
        }
        for (String node : graph.keySet()) {
            DataWorksTopologicalUtils.findDownstreamWorkflow(graph, allDownstreamNodes, node);
        }
        return allDownstreamNodes;
    }

    public static void findDownstreamWorkflow(Map<String, List<String>> graph, Map<String, Set<String>> allDownstreamNodes, String node) {
        if (!allDownstreamNodes.get(node).isEmpty()) {
            return;
        }
        allDownstreamNodes.get(node).addAll((Collection<String>)graph.get(node));
        for (String downstream : graph.get(node)) {
            DataWorksTopologicalUtils.findDownstreamWorkflow(graph, allDownstreamNodes, downstream);
            allDownstreamNodes.get(node).addAll((Collection<String>)allDownstreamNodes.get(downstream));
        }
    }
}

