/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.newide.handler;

import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.StatisticOp;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.spec.domain.dataworks.NodeMainSpec;
import com.aliyun.migration.spec.domain.dataworks.common.DependencyNodeSpec;
import com.aliyun.migration.spec.domain.dataworks.common.DependencySingleSpec;
import com.aliyun.migration.spec.domain.dataworks.common.ElementKind;
import com.aliyun.migration.spec.domain.dataworks.node.DataWorksNodeTypeUtils;
import com.aliyun.migration.spec.domain.dataworks.node.NodeSingleSpec;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.DwNewideClient;
import com.aliyun.migration.workflow.migration.dw.newide.converter.node.AbstractNodeConverter;
import com.aliyun.migration.workflow.migration.dw.newide.converter.node.DwNewideConvertFactory;
import com.aliyun.migration.workflow.migration.dw.newide.converter.workflow.WorkflowConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleNodeSubmiter {
    private static final Logger log = LoggerFactory.getLogger(SingleNodeSubmiter.class);
    private WorkflowProjectPackage workflowProjectPackage;
    private TaskContext taskContext;
    protected DataWorksNodeTypeUtils dataWorksNodeTypeUtils;
    protected DwNewideClient client;
    protected Boolean crazyMode = false;
    protected BwmConfiguration taskContextConf;

    public SingleNodeSubmiter(WorkflowProjectPackage workflowProjectPackage, TaskContext taskContext, DataWorksNodeTypeUtils dataWorksNodeTypeUtils, DwNewideClient client, Boolean crazyMode) {
        this.workflowProjectPackage = workflowProjectPackage;
        this.taskContext = taskContext;
        this.dataWorksNodeTypeUtils = dataWorksNodeTypeUtils;
        this.client = client;
        this.crazyMode = crazyMode;
        this.setConf(BwmConfiguration.from((String)taskContext.getBwmConfiguration()));
    }

    public void setConf(BwmConfiguration taskContextConf) {
        this.taskContextConf = Objects.isNull(taskContextConf) ? BwmConfiguration.newDefault() : (Objects.nonNull(taskContextConf.get("conf")) ? taskContextConf.getConfiguration("conf") : taskContextConf);
    }

    public void importSingleNodes() {
        WorkflowProject workflowProject = this.workflowProjectPackage.getWorkflowProject();
        List workflowList = this.workflowProjectPackage.getWorkflowList();
        StatisticOp statisticOp = this.taskContext.getStatisticOp();
        statisticOp.addWorkflowTotal(workflowList.size());
        HashMap<String, List> existedSingleNodeInProject = new HashMap<String, List>();
        for (Workflow workflow : workflowList) {
            if (workflow.getIsBusiness() == null || !workflow.getIsBusiness().booleanValue() || CollectionUtils.isEmpty((Collection)workflow.getWorkflowNodes())) continue;
            for (WorkflowNode node : workflow.getWorkflowNodes()) {
                if (!StringUtils.isNotBlank((CharSequence)node.getProjectId())) continue;
                if (!existedSingleNodeInProject.containsKey(node.getProjectId())) {
                    log.info("\u4e3a\u5224\u65ad\u521b\u5efa/\u66f4\u65b0\uff0c\u83b7\u53d6project\u4e0b\u5df2\u7ecf\u5b58\u5728\u7684\u72ec\u7acb\u8282\u70b9");
                    existedSingleNodeInProject.put(node.getProjectId(), this.client.getSingleNodeSpecs(node.getProjectId()));
                }
                NodeSingleSpec existTargetNode = this.getExistTargetNodeSpec((List)existedSingleNodeInProject.get(node.getProjectId()), node, workflow);
                this.createOrUpdateNode(node, existTargetNode, workflow);
            }
        }
    }

    private NodeSingleSpec getExistTargetNodeSpec(List<NodeSingleSpec> exsitedNodeList, WorkflowNode workflowNode, Workflow workflow) {
        for (NodeSingleSpec exsitNode : exsitedNodeList) {
            if (!StringUtils.equals((CharSequence)exsitNode.getId(), (CharSequence)workflowNode.getTNodeId()) && !StringUtils.equals((CharSequence)exsitNode.getId(), (CharSequence)workflowNode.getNodeId())) continue;
            return exsitNode;
        }
        String uploadPath = this.makePath(workflow, workflowNode);
        for (NodeSingleSpec exsitNode : exsitedNodeList) {
            if (!StringUtils.equals((CharSequence)exsitNode.getScript().getPath(), (CharSequence)uploadPath)) continue;
            if (this.isManual(workflowNode).booleanValue() && StringUtils.equals((CharSequence)exsitNode.getTrigger().getType(), (CharSequence)"Manual")) {
                return exsitNode;
            }
            if (this.isManual(workflowNode).booleanValue() || !StringUtils.equals((CharSequence)exsitNode.getTrigger().getType(), (CharSequence)"Scheduler")) continue;
            return exsitNode;
        }
        return null;
    }

    private NodeSingleSpec convertNode(WorkflowNode workflowNode, NodeSingleSpec existedNode, Workflow workflow) {
        AbstractNodeConverter converter;
        try {
            converter = DwNewideConvertFactory.buildConvert(workflowNode.getNodeType(), this.workflowProjectPackage, this.taskContextConf, this.dataWorksNodeTypeUtils);
        }
        catch (Exception e) {
            log.error("Node Converter Error! {}, {}", (Object)workflowNode.getNodeType(), (Object)e);
            return null;
        }
        if (existedNode != null) {
            workflowNode.setTNodeId(existedNode.getId());
        } else {
            workflowNode.setTNodeId(null);
        }
        NodeSingleSpec nodeSpec = converter.convert(workflowNode, existedNode);
        nodeSpec.getScript().setPath(this.makePath(workflow, workflowNode));
        if (workflowNode.getCustomProperties() == null) {
            workflowNode.setCustomProperties(new HashMap());
        }
        workflowNode.getCustomProperties().put("spec", NodeSingleSpec.getNodeSingleSpecJson((NodeSingleSpec)nodeSpec).toJSONString(new JSONWriter.Feature[0]));
        return nodeSpec;
    }

    private void createOrUpdateNode(WorkflowNode workflowNode, NodeSingleSpec existedNode, Workflow workflow) {
        NodeSingleSpec nodeSpec = this.convertNode(workflowNode, existedNode, workflow);
        if (nodeSpec == null) {
            return;
        }
        NodeMainSpec nodeMainSpec = new NodeMainSpec();
        nodeMainSpec.setVersion("1.1.0");
        nodeMainSpec.setKind(ElementKind.NODE);
        nodeMainSpec.setSpec(List.of(nodeSpec));
        DependencyNodeSpec dependency = new DependencyNodeSpec();
        if (workflowNode.getTNodeId() != null) {
            dependency.setNodeId(workflowNode.getTNodeId());
        } else {
            dependency.setNodeId(workflowNode.getNodeId());
        }
        dependency.setDepends(new ArrayList());
        for (String parentId : workflowNode.getParentTargetIds()) {
            DependencySingleSpec parentDependency = new DependencySingleSpec();
            parentDependency.setType("Normal");
            parentDependency.setOutput(parentId + "_out");
            dependency.getDepends().add(parentDependency);
        }
        nodeMainSpec.setFlow(List.of(dependency));
        if (existedNode == null) {
            log.info("create node projectId={} workflowName={} nodeName={}", new Object[]{workflowNode.getProjectId(), workflowNode.getWorkflowName(), workflowNode.getNodeName()});
            String result = null;
            result = this.isManual(workflowNode) != false ? this.client.createManualNode(workflowNode.getProjectId(), null, NodeMainSpec.getNodeMainSpecJson((NodeMainSpec)nodeMainSpec).toJSONString(new JSONWriter.Feature[0])) : this.client.createNode(workflowNode.getProjectId(), null, NodeMainSpec.getNodeMainSpecJson((NodeMainSpec)nodeMainSpec).toJSONString(new JSONWriter.Feature[0]));
            if (result != null) {
                workflowNode.setTNodeId(result);
                this.taskContext.getStatisticOp().addWorkflowNodeSuccess(workflowNode.getNodeId() + "_" + workflowNode.getNodeName());
            } else {
                this.taskContext.getStatisticOp().addWorkflowNodeFailure(workflowNode.getNodeId(), "create node error");
            }
        } else {
            log.info("update node projectId={} workflowName={} nodeName={}", new Object[]{workflowNode.getProjectId(), workflowNode.getWorkflowName(), workflowNode.getNodeName()});
            if (this.client.updateNode(workflowNode.getProjectId(), existedNode.getId(), NodeMainSpec.getNodeMainSpecJson((NodeMainSpec)nodeMainSpec).toJSONString(new JSONWriter.Feature[0])).booleanValue()) {
                this.taskContext.getStatisticOp().addWorkflowNodeSuccess(workflowNode.getNodeId() + "_" + workflowNode.getNodeName());
            } else {
                this.taskContext.getStatisticOp().addWorkflowNodeFailure(workflowNode.getNodeId(), "update node error");
            }
        }
    }

    private String makePath(Workflow workflow, WorkflowNode workflowNode) {
        Object nodePath = "";
        if (StringUtils.isNotBlank((CharSequence)workflow.getCategoryValue())) {
            nodePath = workflow.getCategoryValue() + "/";
        }
        if (!(StringUtils.equals((CharSequence)workflow.getWorkflowName(), (CharSequence)"DataWorks\u72ec\u7acb\u5468\u671f\u8282\u70b9\u96c6") || StringUtils.equals((CharSequence)workflow.getWorkflowName(), (CharSequence)"DataWorks\u72ec\u7acb\u624b\u52a8\u8282\u70b9\u96c6") || StringUtils.equals((CharSequence)workflow.getWorkflowName(), (CharSequence)"DataWorks\u4e34\u65f6\u67e5\u8be2"))) {
            nodePath = (String)nodePath + workflow.getWorkflowName() + "/";
        }
        if (StringUtils.isNotBlank((CharSequence)workflowNode.getCategoryValue())) {
            if (((String)(nodePath = (String)nodePath + workflowNode.getCategoryValue())).endsWith(workflowNode.getNodeName())) {
                nodePath = ((String)nodePath).substring(0, ((String)nodePath).length() - workflowNode.getNodeName().length());
            }
            nodePath = (String)nodePath + "/" + WorkflowConverter.nameStandard(workflowNode.getNodeName());
        } else {
            nodePath = (String)nodePath + WorkflowConverter.nameStandard(workflowNode.getNodeName());
        }
        nodePath = ((String)nodePath).replaceAll("/+", "/");
        if (((String)nodePath).startsWith("/")) {
            nodePath = ((String)nodePath).substring(1);
        }
        return nodePath;
    }

    private Boolean isManual(WorkflowNode node) {
        if (node != null && node.getTrigger() != null && StringUtils.equalsIgnoreCase((CharSequence)node.getTrigger().getType(), (CharSequence)"Manual")) {
            return true;
        }
        return false;
    }
}

