/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.newide.converter.resource;

import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.spec.domain.dataworks.common.DatasourceSpec;
import com.aliyun.migration.spec.domain.dataworks.common.ElementKind;
import com.aliyun.migration.spec.domain.dataworks.common.RuntimeResourceSpec;
import com.aliyun.migration.spec.domain.dataworks.common.ScriptSpec;
import com.aliyun.migration.spec.domain.dataworks.resource.FileSpec;
import com.aliyun.migration.spec.domain.dataworks.resource.ResourceMainSpec;
import com.aliyun.migration.spec.domain.dataworks.resource.ResourceSpec;
import com.aliyun.migration.spec.domain.dataworks.resource.StorageSpec;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFileConverter {
    private static final Logger log = LoggerFactory.getLogger(ResourceFileConverter.class);
    protected BwmConfiguration taskContextConf;

    public void setConf(BwmConfiguration taskContextConf) {
        this.taskContextConf = Objects.isNull(taskContextConf) ? BwmConfiguration.newDefault() : (Objects.nonNull(taskContextConf.get("conf")) ? taskContextConf.getConfiguration("conf") : taskContextConf);
    }

    public String convert(WorkflowFileResource workflowFileResource, String exsitedId) {
        ResourceMainSpec resourceMainSpec = new ResourceMainSpec();
        resourceMainSpec.setVersion("1.1.0");
        resourceMainSpec.setKind(ElementKind.RESOURCE);
        resourceMainSpec.setSpec(new ArrayList());
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.setName(workflowFileResource.getName());
        resourceSpec.setType("file");
        if (exsitedId != null) {
            resourceSpec.setId(exsitedId);
        }
        resourceSpec.setScript(new ScriptSpec());
        Object onlinePath = workflowFileResource.getFolder() + "/" + workflowFileResource.getName();
        onlinePath = ((String)onlinePath).replaceAll("//", "/");
        if (((String)onlinePath).startsWith("/")) {
            onlinePath = ((String)onlinePath).substring(1);
        }
        resourceSpec.getScript().setPath((String)onlinePath);
        resourceSpec.getScript().setRuntime(new HashMap());
        resourceSpec.getScript().getRuntime().put("command", workflowFileResource.getFileType());
        if (new File(workflowFileResource.getPath()).exists()) {
            try {
                String content = FileUtils.readFileToString((File)new File(workflowFileResource.getPath()));
                resourceSpec.getScript().setContent(content);
            }
            catch (Exception e) {
                resourceSpec.getScript().setContent("");
                log.error("Error reading file: {}\n {}", (Object)workflowFileResource.getPath(), (Object)e.getMessage());
            }
        } else {
            resourceSpec.getScript().setContent("");
            log.error("File not found: {}", (Object)workflowFileResource.getPath());
        }
        resourceSpec.setRuntimeResource(new RuntimeResourceSpec());
        String targetResourceGroup = (String)this.taskContextConf.getValue("resource.group.identifier", (Object)"null", (Object)"", String.class, BwmServiceErrorCode.CONFIG_ERROR);
        if (targetResourceGroup != null) {
            resourceSpec.getRuntimeResource().setResourceGroup(targetResourceGroup);
        }
        resourceSpec.setFileSpec(new FileSpec());
        resourceSpec.getFileSpec().setPath((String)onlinePath);
        resourceSpec.getFileSpec().setStorage(new StorageSpec());
        resourceSpec.getFileSpec().getStorage().setType("local");
        resourceSpec.setDatasource(new DatasourceSpec());
        resourceSpec.getDatasource().setName("emttest");
        resourceSpec.getDatasource().setType("emr");
        resourceMainSpec.setSpec(List.of(resourceSpec));
        return ResourceMainSpec.getResourceMainSpecJson((ResourceMainSpec)resourceMainSpec).toJSONString(new JSONWriter.Feature[0]);
    }
}

