/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.newide.converter.node;

import com.aliyun.migration.spec.domain.dataworks.node.NodeSingleSpec;
import com.aliyun.migration.spec.domain.dataworks.node.SubflowSpec;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.dw.newide.converter.node.DefaultNodeConverter;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubprocessNodeConverter
extends DefaultNodeConverter {
    private static final Logger log = LoggerFactory.getLogger(SubprocessNodeConverter.class);

    @Override
    public NodeSingleSpec convert(WorkflowNode workflowNode, NodeSingleSpec existedNode) {
        workflowNode.setNodeName(workflowNode.getNodeName() + "_SP");
        NodeSingleSpec nodeSingleSpec = super.convert(workflowNode, existedNode);
        String subprocessId = workflowNode.getScript();
        List workflowList = this.workflowProjectPackage.getWorkflowList();
        List dependWorkflowList = ListUtils.emptyIfNull((List)workflowList).stream().filter(x -> x.getWorkflowId().equalsIgnoreCase(String.valueOf(subprocessId))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(dependWorkflowList)) {
            nodeSingleSpec.setSubflow(new SubflowSpec());
            nodeSingleSpec.getSubflow().setId(((Workflow)dependWorkflowList.get(0)).getTWorkflowId());
        } else {
            log.error("\u672a\u627e\u5230\u5b50\u6d41\u7a0b {}", (Object)subprocessId);
            nodeSingleSpec.setSubflow(new SubflowSpec());
            nodeSingleSpec.getSubflow().setId(subprocessId);
        }
        nodeSingleSpec.getScript().setContent("");
        return nodeSingleSpec;
    }
}

