/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.newide.converter.node;

import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.spec.domain.dataworks.node.DataWorksNodeTypeUtils;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.dw.newide.converter.node.AbstractNodeConverter;
import com.aliyun.migration.workflow.migration.dw.newide.converter.node.ComponentSqlNodeConverter;
import com.aliyun.migration.workflow.migration.dw.newide.converter.node.ControllerAssignmentConverter;
import com.aliyun.migration.workflow.migration.dw.newide.converter.node.ControllerJoinConverter;
import com.aliyun.migration.workflow.migration.dw.newide.converter.node.DINodeConverter;
import com.aliyun.migration.workflow.migration.dw.newide.converter.node.DefaultNodeConverter;
import com.aliyun.migration.workflow.migration.dw.newide.converter.node.EmrShellNodeConverter;
import com.aliyun.migration.workflow.migration.dw.newide.converter.node.ForeachNodeConverter;
import com.aliyun.migration.workflow.migration.dw.newide.converter.node.LindormSparkSqlNodeConverter;
import com.aliyun.migration.workflow.migration.dw.newide.converter.node.PythonNdeConverter;
import com.aliyun.migration.workflow.migration.dw.newide.converter.node.ShellNodeConverter;
import com.aliyun.migration.workflow.migration.dw.newide.converter.node.SubprocessNodeConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwNewideConvertFactory {
    private static final Logger log = LoggerFactory.getLogger(DwNewideConvertFactory.class);
    private static Map<DataWorksNodeTypeUtils.CustomCodeProgramType, AbstractNodeConverter> CONVERTMAP = new HashMap<DataWorksNodeTypeUtils.CustomCodeProgramType, AbstractNodeConverter>();

    public static AbstractNodeConverter buildConvert(String type, WorkflowProjectPackage workflowProjectPackage, BwmConfiguration bwmConfiguration, DataWorksNodeTypeUtils dataWorksNodeTypeUtils) {
        if (StringUtils.isBlank((String)type)) {
            log.error("type is null {}", (Object)type);
            return new DefaultNodeConverter();
        }
        DataWorksNodeTypeUtils.CustomCodeProgramType resType = dataWorksNodeTypeUtils.getNodeType(type);
        if (!Objects.isNull(resType)) {
            AbstractNodeConverter converter = CONVERTMAP.getOrDefault(resType, new DefaultNodeConverter());
            converter.setConf(bwmConfiguration);
            converter.setWorkflowProjectPackage(workflowProjectPackage);
            converter.setDataWorksNodeTypeUtils(dataWorksNodeTypeUtils);
            return converter;
        }
        log.info("type not supported: {}", (Object)type);
        throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.BWM_TYPE_NOT_SUPPORTED_ERROR);
    }

    static {
        CONVERTMAP.put(DataWorksNodeTypeUtils.CustomCodeProgramType.DIDE_SHELL, new ShellNodeConverter());
        CONVERTMAP.put(DataWorksNodeTypeUtils.CustomCodeProgramType.VIRTUAL, new DefaultNodeConverter());
        CONVERTMAP.put(DataWorksNodeTypeUtils.CustomCodeProgramType.SUB_PROCESS, new SubprocessNodeConverter());
        CONVERTMAP.put(DataWorksNodeTypeUtils.CustomCodeProgramType.DI, new DINodeConverter());
        CONVERTMAP.put(DataWorksNodeTypeUtils.CustomCodeProgramType.CONTROLLER_JOIN, new ControllerJoinConverter());
        CONVERTMAP.put(DataWorksNodeTypeUtils.CustomCodeProgramType.CONTROLLER_TRAVERSE, new ForeachNodeConverter());
        CONVERTMAP.put(DataWorksNodeTypeUtils.CustomCodeProgramType.EMR_SHELL, new EmrShellNodeConverter());
        CONVERTMAP.put(DataWorksNodeTypeUtils.CustomCodeProgramType.PYTHON, new PythonNdeConverter());
        CONVERTMAP.put(DataWorksNodeTypeUtils.CustomCodeProgramType.CONTROLLER_ASSIGNMENT, new ControllerAssignmentConverter());
        CONVERTMAP.put(DataWorksNodeTypeUtils.CustomCodeProgramType.COMPONENT_SQL, new ComponentSqlNodeConverter());
        CONVERTMAP.put(DataWorksNodeTypeUtils.CustomCodeProgramType.LINDORM_SPARK_SQL, new LindormSparkSqlNodeConverter());
    }
}

