/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.newide.converter.node;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.spec.domain.dataworks.node.NodeSingleSpec;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.dw.newide.converter.node.DefaultNodeConverter;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerJoinConverter
extends DefaultNodeConverter {
    private static final Logger log = LoggerFactory.getLogger(ControllerJoinConverter.class);

    @Override
    public NodeSingleSpec convert(WorkflowNode workflowNode, NodeSingleSpec existedNode) {
        HashMap nodeIdProjectNameMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)this.workflowProjectPackage.getWorkflowList())) {
            this.workflowProjectPackage.getWorkflowList().forEach(wf -> {
                if (CollectionUtils.isNotEmpty((Collection)wf.getWorkflowNodes())) {
                    wf.getWorkflowNodes().forEach(node -> nodeIdProjectNameMap.put(node.getNodeId(), node.getProjectName()));
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)workflowNode.getScript())) {
            JSONObject controllerJoinScriptJson = JSONObject.parseObject((String)workflowNode.getScript());
            if (controllerJoinScriptJson != null && controllerJoinScriptJson.containsKey("branchList")) {
                String nodeId;
                String nodeOutputName;
                JSONObject branchJson;
                String branchListJsonStr = controllerJoinScriptJson.getString("branchList");
                JSONArray branchListJson = JSONArray.parseArray((String)branchListJsonStr, (JSONReader.Feature[])new JSONReader.Feature[0]);
                if (branchListJson != null && branchListJson.size() > 0 && (branchJson = branchListJson.getJSONObject(0)) != null && branchJson.containsKey("node") && StringUtils.isNotBlank((CharSequence)(nodeOutputName = branchJson.getString("node"))) && nodeOutputName.contains(".") && nodeOutputName.endsWith("_out") && nodeIdProjectNameMap.containsKey(nodeId = nodeOutputName.substring(nodeOutputName.indexOf(".") + 1, nodeOutputName.length() - 4))) {
                    String projectName = (String)nodeIdProjectNameMap.get(nodeId);
                    branchJson.put((Object)"node", (Object)String.format("%s.%s_out", projectName, nodeId));
                }
                controllerJoinScriptJson.put((Object)"branchList", (Object)branchListJson.toJSONString(new JSONWriter.Feature[0]));
            }
            workflowNode.setScript(controllerJoinScriptJson.toJSONString(new JSONWriter.Feature[0]));
        } else {
            log.warn("ControllerJoinConverter script is null");
        }
        NodeSingleSpec result = super.convert(workflowNode, existedNode);
        return result;
    }
}

