/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.dsv2.convert;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.http.HttpParameters;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(HttpNodeConvert.class);

    public HttpNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        List param;
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("deepcopy failed, tgtworkflownode is null");
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.PACKAGE_CONVERT_FAILED, (String)"copy workflownode failed");
        }
        HttpParameters parameter = (HttpParameters)GsonUtils.fromJsonString((String)workflowNode.getScript(), (Type)TypeToken.get(HttpParameters.class).getType());
        String cmd = "curl -X " + parameter.getHttpMethod().name() + " -s -w \"\\n%{http_code}\" ";
        Object url = parameter.getUrl();
        parameter.getHttpMethod().name();
        if (CollectionUtils.isNotEmpty((Collection)parameter.getHttpParams()) && CollectionUtils.isNotEmpty(param = parameter.getHttpParams().stream().map(h -> h.getProp() + "=" + h.getValue()).collect(Collectors.toList()))) {
            String query = String.join((CharSequence)"&", param);
            url = (String)url + "?" + query;
        }
        cmd = cmd + " '" + (String)url + "' | { \n    read body \n    read code\n }";
        tgtworkflowNode.setScript("# get http status $code get response body $body \n" + cmd);
        tgtworkflowNode.setNodeType(this.getNodeType(workflowNode));
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        Map ownerMap = this.getOwnerMapping(this.bwmConfiguration);
        tgtNodes.forEach(node -> {
            if (ownerMap.containsKey(node.getOwner())) {
                node.setOwner((String)ownerMap.get(node.getOwner()));
            }
        });
        return tgtNodes;
    }

    protected String getNodeType(WorkflowNode workflowNode) {
        return this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.shellNodeType", CodeProgramType.DIDE_SHELL.getName());
    }
}

