/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.dsv2.convert;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.TaskDefinition;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvert;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvertFactory;
import com.aliyun.migration.workflow.migration.common.convert.DefaultNodeConvert;
import com.aliyun.migration.workflow.migration.common.type.DolphinV2NodeType;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.workflow.migration.transform.dw.dsv2.convert.ConditionsNodeConvert;
import com.workflow.migration.transform.dw.dsv2.convert.DataxNodeConvert;
import com.workflow.migration.transform.dw.dsv2.convert.DependentNodeConvert;
import com.workflow.migration.transform.dw.dsv2.convert.HiveCliNodeConvert;
import com.workflow.migration.transform.dw.dsv2.convert.HttpNodeConvert;
import com.workflow.migration.transform.dw.dsv2.convert.MrNodeConvert;
import com.workflow.migration.transform.dw.dsv2.convert.ProcedureNodeConvert;
import com.workflow.migration.transform.dw.dsv2.convert.PythonNodeConvert;
import com.workflow.migration.transform.dw.dsv2.convert.ShellNodeConvert;
import com.workflow.migration.transform.dw.dsv2.convert.SparkNodeConvert;
import com.workflow.migration.transform.dw.dsv2.convert.SqlNodeConvert;
import com.workflow.migration.transform.dw.dsv2.convert.SqoopNodeConvert;
import com.workflow.migration.transform.dw.dsv2.convert.SubProcessNodeConvert;
import com.workflow.migration.transform.dw.dsv2.convert.SwitchNodeConvert;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dolphin2ConvertFactory
extends AbstractConvertFactory {
    private static final Logger log = LoggerFactory.getLogger(Dolphin2ConvertFactory.class);

    private DolphinV2NodeType getTaskType(String taskTypeStr) {
        try {
            return DolphinV2NodeType.of((String)taskTypeStr);
        }
        catch (Exception e) {
            log.error("get taskType error");
            return null;
        }
    }

    public AbstractConvert<List<WorkflowNode>> getNodeListConvert(String taskTypeStr, TaskContext taskContext, Workflow workflow) {
        DolphinV2NodeType taskType = this.getTaskType(taskTypeStr);
        if (taskType == null) {
            log.warn("not supported thie tasktype {}, use default convert", (Object)taskTypeStr);
            return new DefaultNodeConvert(taskContext, workflow);
        }
        switch (taskType) {
            case PROCEDURE: {
                return new ProcedureNodeConvert(taskContext, workflow);
            }
            case SQL: {
                return new SqlNodeConvert(taskContext, workflow);
            }
            case PYTHON: {
                return new PythonNodeConvert(taskContext, workflow);
            }
            case CONDITIONS: {
                return new ConditionsNodeConvert(taskContext, workflow);
            }
            case SUB_PROCESS: {
                return new SubProcessNodeConvert(taskContext, workflow);
            }
            case DEPENDENT: {
                return new DependentNodeConvert(taskContext, workflow);
            }
            case SHELL: {
                return new ShellNodeConvert(taskContext, workflow);
            }
            case SWITCH: {
                return new SwitchNodeConvert(taskContext, workflow);
            }
            case HTTP: {
                return new HttpNodeConvert(taskContext, workflow);
            }
            case SPARK: {
                return new SparkNodeConvert(taskContext, workflow);
            }
            case MR: {
                return new MrNodeConvert(taskContext, workflow);
            }
            case HIVECLI: {
                return new HiveCliNodeConvert(taskContext, workflow);
            }
            case DATAX: {
                return new DataxNodeConvert(taskContext, workflow);
            }
            case SQOOP: {
                return new SqoopNodeConvert(taskContext, workflow);
            }
        }
        return new DefaultNodeConvert(taskContext, workflow);
    }

    public AbstractConvert<List<WorkflowNode>> getCustomNodeConvert(TaskContext taskContext, WorkflowNode workflowNode, Workflow workflow) {
        String originScript = workflowNode.getOriginScript();
        TaskDefinition taskDefinition = (TaskDefinition)BwmJsonUtil.parseObject((String)originScript, TaskDefinition.class);
        String taskType = taskDefinition.getTaskType();
        workflowNode.setNodeId(String.valueOf(taskDefinition.getCode()));
        workflowNode.setNodeName(taskDefinition.getName());
        workflowNode.setNodeType(taskDefinition.getTaskType());
        workflowNode.setPriority(Integer.valueOf(taskDefinition.getTaskPriority().getCode()));
        workflowNode.setScript(taskDefinition.getTaskParams());
        return this.getNodeListConvert(taskType, taskContext, workflow);
    }
}

