/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.reader.dolphinscheduler;

import com.aliyun.dataworks.client.command.CommandApp;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.BatchExportProcessDefinitionByIdsRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.PaginateData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.PaginateResponse;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.QueryProcessDefinitionByPaginateRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DolphinschedulerApiV3Service;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.v320.DagDataSchedule;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import com.aliyun.migrationx.common.utils.JSONUtils;
import com.google.gson.JsonElement;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinSchedulerSingleJsonReader
extends CommandApp {
    private static final Logger log = LoggerFactory.getLogger(DolphinSchedulerSingleJsonReader.class);

    public static void main(String[] args) throws Exception {
        new DolphinSchedulerSingleJsonReader().run(args);
    }

    public void run(String[] args) throws Exception {
        Options options = this.getOptions();
        CommandLine commandLine = this.getCommandLine(options, args);
        String endpoint = commandLine.getOptionValue("e");
        String token = commandLine.getOptionValue("t");
        String dolphinProjectCode = commandLine.getOptionValue("p");
        String targetFile = commandLine.getOptionValue("f");
        String[] projectCodeList = dolphinProjectCode.split(",");
        DolphinschedulerApiV3Service dolphinschedulerApiV3Service = new DolphinschedulerApiV3Service(endpoint, token);
        File file = new File(targetFile);
        if (file.exists() && !file.delete()) {
            log.error("target file exists and can not be deleted, file: {}", (Object)targetFile);
            throw new BizException(ErrorCode.NO_PERMISSION, new Object[]{"delete file " + targetFile});
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            AtomicBoolean isFirst = new AtomicBoolean(true);
            for (String projectCode : projectCodeList) {
                this.readDagDataSchedule(dolphinschedulerApiV3Service, projectCode, writer, isFirst);
            }
            writer.newLine();
            writer.write("]");
            writer.flush();
        }
        catch (IOException e) {
            log.error("write to target file error", (Throwable)e);
        }
        log.info("read dolphin scheduler success, dolphin scheduler json target path: {}", (Object)targetFile);
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addRequiredOption("e", "endpoint", true, "dolphinscheduler endpoint, example: http://123.23.23.34:12345");
        options.addRequiredOption("t", "token", true, "dolphinscheduler token");
        options.addRequiredOption("p", "projectCode", true, "dolphinscheduler project code");
        options.addRequiredOption("f", "targetFile", true, "dolphinscheduler json target path");
        return options;
    }

    private void readDagDataSchedule(DolphinschedulerApiV3Service dolphinschedulerApiV3Service, String projectCode, BufferedWriter writer, AtomicBoolean isFirst) {
        int pageNo = 0;
        int pageSize = 10;
        int total = 0;
        QueryProcessDefinitionByPaginateRequest queryProcessDefinitionByPaginateRequest = new QueryProcessDefinitionByPaginateRequest();
        queryProcessDefinitionByPaginateRequest.setPageNo(Integer.valueOf(pageNo));
        queryProcessDefinitionByPaginateRequest.setPageSize(Integer.valueOf(pageSize));
        queryProcessDefinitionByPaginateRequest.setProjectCode(Long.valueOf(projectCode));
        BatchExportProcessDefinitionByIdsRequest batchExportProcessDefinitionByIdsRequest = new BatchExportProcessDefinitionByIdsRequest();
        batchExportProcessDefinitionByIdsRequest.setPageNo(Integer.valueOf(1));
        batchExportProcessDefinitionByIdsRequest.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        batchExportProcessDefinitionByIdsRequest.setProjectCode(Long.valueOf(projectCode));
        do {
            try {
                queryProcessDefinitionByPaginateRequest.setPageNo(Integer.valueOf(++pageNo));
                PaginateResponse processDefinitionByPaging = dolphinschedulerApiV3Service.queryProcessDefinitionByPaging(queryProcessDefinitionByPaginateRequest);
                PaginateData data = (PaginateData)processDefinitionByPaging.getData();
                total = data.getTotal();
                List processCodeList = data.getTotalList().stream().filter(Objects::nonNull).map(jsonObject -> jsonObject.get("code")).filter(Objects::nonNull).map(JsonElement::getAsLong).map(String::valueOf).collect(Collectors.toList());
                batchExportProcessDefinitionByIdsRequest.setIds(processCodeList);
                String processDefinitionListJson = dolphinschedulerApiV3Service.batchExportProcessDefinitionByIds(batchExportProcessDefinitionByIdsRequest);
                List dagDataScheduleList = JSONUtils.toList((String)processDefinitionListJson, DagDataSchedule.class);
                for (DagDataSchedule dagDataSchedule : dagDataScheduleList) {
                    if (isFirst.get()) {
                        writer.write("[");
                        isFirst.set(false);
                    } else {
                        writer.write(",");
                    }
                    writer.newLine();
                    writer.write(JSONUtils.toJsonString((Object)dagDataSchedule));
                }
                writer.flush();
            }
            catch (Exception e) {
                log.error("read dolphin dag data error: {}", (Object)e.getLocalizedMessage(), (Object)e);
            }
        } while (pageNo * pageSize < total);
    }
}

