/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.ObjIntConsumer;
import java.util.stream.Collectors;
import javax.management.ObjectName;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardThreadExecutor;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.catalina.valves.ErrorReportValve;
import org.apache.catalina.valves.RemoteIpValve;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.coyote.http2.Http2Protocol;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.tomcat.ConfigurableTomcatWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatProtocolHandlerCustomizer;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import org.springframework.util.unit.DataSize;

public class TomcatWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableTomcatWebServerFactory>,
Ordered {
    static final int ORDER = 0;
    private final Environment environment;
    private final ServerProperties serverProperties;

    public TomcatWebServerFactoryCustomizer(Environment environment, ServerProperties serverProperties) {
        this.environment = environment;
        this.serverProperties = serverProperties;
    }

    public int getOrder() {
        return 0;
    }

    public void customize(ConfigurableTomcatWebServerFactory factory) {
        ServerProperties.Tomcat properties = this.serverProperties.getTomcat();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::getBasedir).to(arg_0 -> ((ConfigurableTomcatWebServerFactory)factory).setBaseDirectory(arg_0));
        map.from(properties::getBackgroundProcessorDelay).as(Duration::getSeconds).as(Long::intValue).to(arg_0 -> ((ConfigurableTomcatWebServerFactory)factory).setBackgroundProcessorDelay(arg_0));
        this.customizeRemoteIpValve(factory);
        this.configureExecutor(factory, properties.getThreads());
        map.from((Object)this.serverProperties.getMaxHttpRequestHeaderSize()).asInt(DataSize::toBytes).when(this::isPositive).to(maxHttpRequestHeaderSize -> this.customizeMaxHttpRequestHeaderSize(factory, (int)maxHttpRequestHeaderSize));
        map.from(properties::getMaxHttpResponseHeaderSize).asInt(DataSize::toBytes).when(this::isPositive).to(maxHttpResponseHeaderSize -> this.customizeMaxHttpResponseHeaderSize(factory, (int)maxHttpResponseHeaderSize));
        map.from(properties::getMaxSwallowSize).asInt(DataSize::toBytes).to(maxSwallowSize -> this.customizeMaxSwallowSize(factory, (int)maxSwallowSize));
        map.from(properties::getMaxHttpFormPostSize).asInt(DataSize::toBytes).when(maxHttpFormPostSize -> maxHttpFormPostSize != 0).to(maxHttpFormPostSize -> this.customizeMaxHttpFormPostSize(factory, (int)maxHttpFormPostSize));
        map.from(properties::getAccesslog).when(ServerProperties.Tomcat.Accesslog::isEnabled).to(enabled -> this.customizeAccessLog(factory));
        map.from(properties::getUriEncoding).to(arg_0 -> ((ConfigurableTomcatWebServerFactory)factory).setUriEncoding(arg_0));
        map.from(properties::getConnectionTimeout).to(connectionTimeout -> this.customizeConnectionTimeout(factory, (Duration)connectionTimeout));
        map.from(properties::getMaxConnections).when(this::isPositive).to(maxConnections -> this.customizeMaxConnections(factory, (int)maxConnections));
        map.from(properties::getAcceptCount).when(this::isPositive).to(acceptCount -> this.customizeAcceptCount(factory, (int)acceptCount));
        map.from(properties::getProcessorCache).to(processorCache -> this.customizeProcessorCache(factory, (int)processorCache));
        map.from(properties::getKeepAliveTimeout).to(keepAliveTimeout -> this.customizeKeepAliveTimeout(factory, (Duration)keepAliveTimeout));
        map.from(properties::getMaxKeepAliveRequests).to(maxKeepAliveRequests -> this.customizeMaxKeepAliveRequests(factory, (int)maxKeepAliveRequests));
        map.from(properties::getRelaxedPathChars).as(this::joinCharacters).whenHasText().to(relaxedChars -> this.customizeRelaxedPathChars(factory, (String)relaxedChars));
        map.from(properties::getRelaxedQueryChars).as(this::joinCharacters).whenHasText().to(relaxedChars -> this.customizeRelaxedQueryChars(factory, (String)relaxedChars));
        map.from(properties::isRejectIllegalHeader).to(rejectIllegalHeader -> this.customizeRejectIllegalHeader(factory, (boolean)rejectIllegalHeader));
        this.customizeStaticResources(factory);
        this.customizeErrorReportValve(this.serverProperties.getError(), factory);
    }

    private void configureExecutor(ConfigurableTomcatWebServerFactory factory, ServerProperties.Tomcat.Threads threadProperties) {
        factory.addProtocolHandlerCustomizers(new TomcatProtocolHandlerCustomizer[]{handler -> {
            StandardThreadExecutor executor = new StandardThreadExecutor();
            executor.setMinSpareThreads(threadProperties.getMinSpare());
            executor.setMaxThreads(threadProperties.getMax());
            executor.setMaxQueueSize(threadProperties.getMaxQueueCapacity());
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                executor.setNamePrefix(ObjectName.unquote(protocol.getName()) + "-exec-");
            }
            handler.setExecutor((Executor)executor);
        }});
    }

    private boolean isPositive(int value) {
        return value > 0;
    }

    private void customizeAcceptCount(ConfigurableTomcatWebServerFactory factory, int acceptCount) {
        this.customizeHandler(factory, acceptCount, AbstractProtocol.class, AbstractProtocol::setAcceptCount);
    }

    private void customizeProcessorCache(ConfigurableTomcatWebServerFactory factory, int processorCache) {
        this.customizeHandler(factory, processorCache, AbstractProtocol.class, AbstractProtocol::setProcessorCache);
    }

    private void customizeKeepAliveTimeout(ConfigurableTomcatWebServerFactory factory, Duration keepAliveTimeout) {
        factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            for (UpgradeProtocol upgradeProtocol : handler.findUpgradeProtocols()) {
                if (!(upgradeProtocol instanceof Http2Protocol)) continue;
                Http2Protocol protocol = (Http2Protocol)upgradeProtocol;
                protocol.setKeepAliveTimeout(keepAliveTimeout.toMillis());
            }
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setKeepAliveTimeout((int)keepAliveTimeout.toMillis());
            }
        }});
    }

    private void customizeMaxKeepAliveRequests(ConfigurableTomcatWebServerFactory factory, int maxKeepAliveRequests) {
        this.customizeHandler(factory, maxKeepAliveRequests, AbstractHttp11Protocol.class, AbstractHttp11Protocol::setMaxKeepAliveRequests);
    }

    private void customizeMaxConnections(ConfigurableTomcatWebServerFactory factory, int maxConnections) {
        this.customizeHandler(factory, maxConnections, AbstractProtocol.class, AbstractProtocol::setMaxConnections);
    }

    private void customizeConnectionTimeout(ConfigurableTomcatWebServerFactory factory, Duration connectionTimeout) {
        this.customizeHandler(factory, (int)connectionTimeout.toMillis(), AbstractProtocol.class, AbstractProtocol::setConnectionTimeout);
    }

    private void customizeRelaxedPathChars(ConfigurableTomcatWebServerFactory factory, String relaxedChars) {
        factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> connector.setProperty("relaxedPathChars", relaxedChars)});
    }

    private void customizeRelaxedQueryChars(ConfigurableTomcatWebServerFactory factory, String relaxedChars) {
        factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> connector.setProperty("relaxedQueryChars", relaxedChars)});
    }

    private void customizeRejectIllegalHeader(ConfigurableTomcatWebServerFactory factory, boolean rejectIllegalHeader) {
        factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setRejectIllegalHeader(rejectIllegalHeader);
            }
        }});
    }

    private String joinCharacters(List<Character> content) {
        return content.stream().map(String::valueOf).collect(Collectors.joining());
    }

    private void customizeRemoteIpValve(ConfigurableTomcatWebServerFactory factory) {
        ServerProperties.Tomcat.Remoteip remoteIpProperties = this.serverProperties.getTomcat().getRemoteip();
        String protocolHeader = remoteIpProperties.getProtocolHeader();
        String remoteIpHeader = remoteIpProperties.getRemoteIpHeader();
        if (StringUtils.hasText((String)protocolHeader) || StringUtils.hasText((String)remoteIpHeader) || this.getOrDeduceUseForwardHeaders()) {
            RemoteIpValve valve = new RemoteIpValve();
            valve.setProtocolHeader(StringUtils.hasLength((String)protocolHeader) ? protocolHeader : "X-Forwarded-Proto");
            if (StringUtils.hasLength((String)remoteIpHeader)) {
                valve.setRemoteIpHeader(remoteIpHeader);
            }
            valve.setTrustedProxies(remoteIpProperties.getTrustedProxies());
            valve.setInternalProxies(remoteIpProperties.getInternalProxies());
            try {
                valve.setHostHeader(remoteIpProperties.getHostHeader());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            valve.setPortHeader(remoteIpProperties.getPortHeader());
            valve.setProtocolHeaderHttpsValue(remoteIpProperties.getProtocolHeaderHttpsValue());
            factory.addEngineValves(new Valve[]{valve});
        }
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.getForwardHeadersStrategy() == null) {
            CloudPlatform platform = CloudPlatform.getActive((Environment)this.environment);
            return platform != null && platform.isUsingForwardHeaders();
        }
        return this.serverProperties.getForwardHeadersStrategy() == ServerProperties.ForwardHeadersStrategy.NATIVE;
    }

    private void customizeMaxHttpRequestHeaderSize(ConfigurableTomcatWebServerFactory factory, int maxHttpRequestHeaderSize) {
        this.customizeHandler(factory, maxHttpRequestHeaderSize, AbstractHttp11Protocol.class, AbstractHttp11Protocol::setMaxHttpRequestHeaderSize);
    }

    private void customizeMaxHttpResponseHeaderSize(ConfigurableTomcatWebServerFactory factory, int maxHttpResponseHeaderSize) {
        this.customizeHandler(factory, maxHttpResponseHeaderSize, AbstractHttp11Protocol.class, AbstractHttp11Protocol::setMaxHttpResponseHeaderSize);
    }

    private void customizeMaxSwallowSize(ConfigurableTomcatWebServerFactory factory, int maxSwallowSize) {
        this.customizeHandler(factory, maxSwallowSize, AbstractHttp11Protocol.class, AbstractHttp11Protocol::setMaxSwallowSize);
    }

    private <T extends ProtocolHandler> void customizeHandler(ConfigurableTomcatWebServerFactory factory, int value, Class<T> type, ObjIntConsumer<T> consumer) {
        factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (type.isAssignableFrom(handler.getClass())) {
                consumer.accept((ProtocolHandler)type.cast(handler), value);
            }
        }});
    }

    private void customizeMaxHttpFormPostSize(ConfigurableTomcatWebServerFactory factory, int maxHttpFormPostSize) {
        factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> connector.setMaxPostSize(maxHttpFormPostSize)});
    }

    private void customizeAccessLog(ConfigurableTomcatWebServerFactory factory) {
        ServerProperties.Tomcat tomcatProperties = this.serverProperties.getTomcat();
        AccessLogValve valve = new AccessLogValve();
        PropertyMapper map = PropertyMapper.get();
        ServerProperties.Tomcat.Accesslog accessLogConfig = tomcatProperties.getAccesslog();
        map.from((Object)accessLogConfig.getConditionIf()).to(arg_0 -> ((AccessLogValve)valve).setConditionIf(arg_0));
        map.from((Object)accessLogConfig.getConditionUnless()).to(arg_0 -> ((AccessLogValve)valve).setConditionUnless(arg_0));
        map.from((Object)accessLogConfig.getPattern()).to(arg_0 -> ((AccessLogValve)valve).setPattern(arg_0));
        map.from((Object)accessLogConfig.getDirectory()).to(arg_0 -> ((AccessLogValve)valve).setDirectory(arg_0));
        map.from((Object)accessLogConfig.getPrefix()).to(arg_0 -> ((AccessLogValve)valve).setPrefix(arg_0));
        map.from((Object)accessLogConfig.getSuffix()).to(arg_0 -> ((AccessLogValve)valve).setSuffix(arg_0));
        map.from((Object)accessLogConfig.getEncoding()).whenHasText().to(arg_0 -> ((AccessLogValve)valve).setEncoding(arg_0));
        map.from((Object)accessLogConfig.getLocale()).whenHasText().to(arg_0 -> ((AccessLogValve)valve).setLocale(arg_0));
        map.from((Object)accessLogConfig.isCheckExists()).to(arg_0 -> ((AccessLogValve)valve).setCheckExists(arg_0));
        map.from((Object)accessLogConfig.isRotate()).to(arg_0 -> ((AccessLogValve)valve).setRotatable(arg_0));
        map.from((Object)accessLogConfig.isRenameOnRotate()).to(arg_0 -> ((AccessLogValve)valve).setRenameOnRotate(arg_0));
        map.from((Object)accessLogConfig.getMaxDays()).to(arg_0 -> ((AccessLogValve)valve).setMaxDays(arg_0));
        map.from((Object)accessLogConfig.getFileDateFormat()).to(arg_0 -> ((AccessLogValve)valve).setFileDateFormat(arg_0));
        map.from((Object)accessLogConfig.isIpv6Canonical()).to(arg_0 -> ((AccessLogValve)valve).setIpv6Canonical(arg_0));
        map.from((Object)accessLogConfig.isRequestAttributesEnabled()).to(arg_0 -> ((AccessLogValve)valve).setRequestAttributesEnabled(arg_0));
        map.from((Object)accessLogConfig.isBuffered()).to(arg_0 -> ((AccessLogValve)valve).setBuffered(arg_0));
        factory.addEngineValves(new Valve[]{valve});
    }

    private void customizeStaticResources(ConfigurableTomcatWebServerFactory factory) {
        ServerProperties.Tomcat.Resource resource = this.serverProperties.getTomcat().getResource();
        factory.addContextCustomizers(new TomcatContextCustomizer[]{context -> context.addLifecycleListener(event -> {
            if (event.getType().equals("configure_start")) {
                context.getResources().setCachingAllowed(resource.isAllowCaching());
                if (resource.getCacheTtl() != null) {
                    long ttl = resource.getCacheTtl().toMillis();
                    context.getResources().setCacheTtl(ttl);
                }
            }
        })});
    }

    private void customizeErrorReportValve(ErrorProperties error, ConfigurableTomcatWebServerFactory factory) {
        if (error.getIncludeStacktrace() == ErrorProperties.IncludeAttribute.NEVER) {
            factory.addContextCustomizers(new TomcatContextCustomizer[]{context -> {
                ErrorReportValve valve = new ErrorReportValve();
                valve.setShowServerInfo(false);
                valve.setShowReport(false);
                context.getParent().getPipeline().addValve((Valve)valve);
            }});
        }
    }
}

