/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.util.trie;

import com.aliyun.securitysdk.util.trie.TrieNode;
import com.aliyun.securitysdk.util.trie.converter.BinaryTrieNodeConverter;
import com.aliyun.securitysdk.util.trie.converter.TrieNodeConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;

public class SimpleTrieNode
implements TrieNode {
    protected TrieNode[] children;
    protected TrieNode parent;
    private int capacity;
    private boolean isWildcard = false;
    private boolean isTerminal = false;
    private TrieNodeConverter convertor;
    private boolean prefix;

    public SimpleTrieNode(TrieNode parent, TrieNodeConverter converter, boolean prefix) {
        this.convertor = converter != null ? converter : new BinaryTrieNodeConverter();
        this.capacity = this.convertor.getSize();
        this.children = new TrieNode[this.capacity];
        this.parent = parent;
        this.prefix = prefix;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    public Enumeration<TrieNode> children() {
        return Collections.enumeration(Arrays.asList(this.children));
    }

    @Override
    public TrieNode getChildAt(int childIndex) {
        return this.children[childIndex];
    }

    @Override
    public int getChildCount() {
        return this.children.length;
    }

    @Override
    public int getIndex(TreeNode node) {
        if (node == null) {
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.children.length; ++i) {
                if (!node.equals(this.children[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.children == null || this.children.length == 0;
    }

    @Override
    public void addChild(int index, TrieNode child) {
        this.children[index] = child;
    }

    @Override
    public boolean isWildcard() {
        return this.isWildcard;
    }

    @Override
    public void setWildcard(boolean isWildcard) {
        this.isWildcard = isWildcard;
    }

    @Override
    public boolean isTerminal() {
        return this.isTerminal;
    }

    @Override
    public void setTerminal(boolean isTerminal) {
        this.isTerminal = isTerminal;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public TrieNodeConverter getTrieHandler() {
        return this.convertor;
    }

    @Override
    public void setTrieHandler(TrieNodeConverter trieHandler) {
        this.convertor = trieHandler;
    }

    @Override
    public boolean isPrefix() {
        return this.prefix;
    }

    @Override
    public boolean insert(char[] children, TrieNode parent) {
        if (parent == null) {
            return false;
        }
        if (children != null) {
            int index = children.length - 1;
            if (index < 0) {
                return false;
            }
            TrieNode parentNode = parent;
            TrieNode childNode = null;
            while (index >= 0) {
                int theIndex = parent.isPrefix() ? children.length - 1 - index : index;
                char last = children[theIndex];
                int pos = this.convertor.getPos(last);
                if (pos == -1) {
                    parentNode.setWildcard(true);
                    return true;
                }
                if (pos == -2) {
                    return false;
                }
                childNode = (TrieNode)parentNode.getChildAt(pos);
                if (childNode == null) {
                    childNode = new SimpleTrieNode(parentNode, this.convertor, parent.isPrefix());
                    parentNode.addChild(pos, childNode);
                }
                parentNode = childNode;
                --index;
            }
            parentNode.setTerminal(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean search(char[] children, TrieNode node) {
        if (children != null && node != null) {
            int index = children.length - 1;
            if (index < 0) {
                return false;
            }
            while (index >= 0) {
                int theIndex = node.isPrefix() ? children.length - 1 - index : index;
                char last = children[theIndex];
                int pos = this.convertor.getPos(last);
                if (pos == -2) {
                    return false;
                }
                if ((node = (TrieNode)node.getChildAt(pos)) == null) {
                    return false;
                }
                if (node.isWildcard() && index > 0) {
                    return true;
                }
                --index;
            }
            return node.isTerminal();
        }
        return false;
    }

    @Override
    public int build(List<String> inputs) {
        if (inputs != null) {
            for (String input : inputs) {
                this.insert(input.toCharArray(), this);
            }
            return 1;
        }
        return -1;
    }

    @Override
    public boolean search(String children) {
        if (children != null) {
            return this.search(children.toCharArray(), this);
        }
        return false;
    }
}

