/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.util.matcher;

import com.aliyun.securitysdk.util.matcher.StringMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DelegateStringMatcher
implements StringMatcher {
    private List<StringMatcher> matchers = new ArrayList<StringMatcher>();

    public DelegateStringMatcher() {
    }

    public DelegateStringMatcher(StringMatcher matchers) {
        this.matchers.add(matchers);
    }

    public DelegateStringMatcher(List<StringMatcher> matchers) {
        this.matchers.addAll(matchers);
    }

    public StringMatcher addStringMatchers(List<StringMatcher> matchers) {
        this.matchers.addAll(matchers);
        return this;
    }

    public StringMatcher addStringMatcher(StringMatcher matcher) {
        this.matchers.add(matcher);
        return this;
    }

    @Override
    public boolean matches(String text) {
        for (StringMatcher stringMatcher : this.matchers) {
            if (!stringMatcher.matches(text)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (StringMatcher matcher : this.matchers) {
            matcher.clear();
        }
    }

    public List<StringMatcher> listDelegatedMatchers() {
        return Collections.unmodifiableList(this.matchers);
    }
}

