/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.util;

import java.io.UnsupportedEncodingException;

public class URLDecoder {
    public static String decode(String s, String enc) throws UnsupportedEncodingException {
        boolean needToChange = false;
        boolean hasError = false;
        int numChars = s.length();
        StringBuffer sb = new StringBuffer(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        if (enc.length() == 0) {
            throw new UnsupportedEncodingException("URLDecoder: empty string enc parameter");
        }
        byte[] bytes = null;
        block6: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    ++i;
                    needToChange = true;
                    continue block6;
                }
                case '%': {
                    hasError = false;
                    if (bytes == null) {
                        bytes = new byte[(numChars - i) / 3];
                    }
                    int pos = 0;
                    try {
                        while (i + 2 < numChars && c == '%') {
                            int v = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if (v < 0) {
                                throw new NumberFormatException("URLDecoder: Illegal hex characters in escape (%) pattern - negative value");
                            }
                            bytes[pos++] = (byte)v;
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            hasError = true;
                            ++i;
                        }
                    }
                    catch (NumberFormatException e) {
                        hasError = true;
                        ++i;
                    }
                    sb.append(new String(bytes, 0, pos, enc));
                    if (hasError) {
                        sb.append('%');
                    }
                    needToChange = true;
                    continue block6;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }
}

