/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.util;

import com.aliyun.securitysdk.util.StringUtils;

public class IpFormatter {
    private static final String PREFIX_8 = "0";
    private static final String PREFIX_16 = "0x";
    private static final String IP_DELIMITER = ".";

    public static String format8(byte[] ip) {
        return PREFIX_8 + Long.toOctalString(IpFormatter.format10Actually(ip));
    }

    public static String format10(byte[] ip) {
        return String.valueOf(IpFormatter.format10Actually(ip));
    }

    public static String format16(byte[] ip) {
        return PREFIX_16 + Long.toHexString(IpFormatter.format10Actually(ip)).toLowerCase();
    }

    private static long format10Actually(byte[] ip) {
        long format10 = 0L;
        format10 += ((long)ip[0] & 0xFFL) << 24;
        format10 += ((long)ip[1] & 0xFFL) << 16;
        format10 += ((long)ip[2] & 0xFFL) << 8;
        return format10 += (long)ip[3] & 0xFFL;
    }

    public static String format8Ddn(byte[] ip) {
        String format8 = "";
        format8 = format8 + PREFIX_8 + Integer.toOctalString(ip[0] & 0xFF) + IP_DELIMITER;
        format8 = format8 + PREFIX_8 + Integer.toOctalString(ip[1] & 0xFF) + IP_DELIMITER;
        format8 = format8 + PREFIX_8 + Integer.toOctalString(ip[2] & 0xFF) + IP_DELIMITER;
        format8 = format8 + PREFIX_8 + Integer.toOctalString(ip[3] & 0xFF);
        return format8;
    }

    public static String format10Ddn(byte[] ip) {
        String format10 = "";
        format10 = format10 + ((long)ip[0] & 0xFFL) + IP_DELIMITER;
        format10 = format10 + ((long)ip[1] & 0xFFL) + IP_DELIMITER;
        format10 = format10 + ((long)ip[2] & 0xFFL) + IP_DELIMITER;
        format10 = format10 + ((long)ip[3] & 0xFFL);
        return format10;
    }

    public static String format16Ddn(byte[] ip) {
        String format16 = "";
        format16 = format16 + PREFIX_16 + Integer.toHexString(ip[0] & 0xFF).toLowerCase() + IP_DELIMITER;
        format16 = format16 + PREFIX_16 + Integer.toHexString(ip[1] & 0xFF).toLowerCase() + IP_DELIMITER;
        format16 = format16 + PREFIX_16 + Integer.toHexString(ip[2] & 0xFF).toLowerCase() + IP_DELIMITER;
        format16 = format16 + PREFIX_16 + Integer.toHexString(ip[3] & 0xFF).toLowerCase();
        return format16;
    }

    public static String formatJavaIp(String ip) {
        if (ip.length() > 15) {
            return ip;
        }
        String[] ipParts = ip.split("\\.");
        if (ipParts.length != 4) {
            return ip;
        }
        if (!(StringUtils.isDigits(ipParts[0]) && StringUtils.isDigits(ipParts[1]) && StringUtils.isDigits(ipParts[2]) && StringUtils.isDigits(ipParts[3]))) {
            return ip;
        }
        String formatJavaIp = "";
        formatJavaIp = formatJavaIp + Integer.valueOf(ipParts[0]) + IP_DELIMITER;
        formatJavaIp = formatJavaIp + Integer.valueOf(ipParts[1]) + IP_DELIMITER;
        formatJavaIp = formatJavaIp + Integer.valueOf(ipParts[2]) + IP_DELIMITER;
        formatJavaIp = formatJavaIp + Integer.valueOf(ipParts[3]);
        return formatJavaIp;
    }
}

