/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.url.ssrf.http;

import com.aliyun.securitysdk.url.SSRFChecker;
import com.aliyun.securitysdk.url.exception.SSRFUnsafeConnectionException;
import com.aliyun.securitysdk.url.ssrf.http.AbstractSecurityRedirectStrategy;
import com.aliyun.securitysdk.url.ssrf.http.SecurityRedirectStrategy;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;

public class SecurityRedirectWhenEnableDnsCacheStrategy
extends AbstractSecurityRedirectStrategy {
    private static AbstractSecurityRedirectStrategy instance;

    public SecurityRedirectWhenEnableDnsCacheStrategy() {
        super(SecurityRedirectStrategy.CheckMethod.CHECK_URL_WITHOUT_CONNECTION);
    }

    @Override
    void checkSSRFAttack(URI uri) {
        if (!this.ssrfChecker.checkUrlWithoutConnection(uri.toString())) {
            InetAddress address = null;
            try {
                address = InetAddress.getByName(uri.getHost());
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            throw new SSRFUnsafeConnectionException("ssrf attack:" + address, address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static AbstractSecurityRedirectStrategy getInstance(SSRFChecker ssrfChecker) {
        if (instance != null) return instance;
        Class<SecurityRedirectWhenEnableDnsCacheStrategy> clazz = SecurityRedirectWhenEnableDnsCacheStrategy.class;
        synchronized (SecurityRedirectWhenEnableDnsCacheStrategy.class) {
            if (instance != null) return instance;
            instance = new SecurityRedirectWhenEnableDnsCacheStrategy();
            instance.init(ssrfChecker);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }
}

