/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.url.ssrf.checkcondition;

import com.aliyun.securitysdk.url.ssrf.checkcondition.SSRFNetHooksCheckCondition;
import com.aliyun.securitysdk.url.ssrf.policy.CompatibleSsrfCheckerRegister;
import com.aliyun.securitysdk.url.ssrf.strategy.InetAddressHostnameResolveStrategies;
import com.aliyun.securitysdk.util.IpFormatter;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;

public class ExpirationCacheSSRFNetHooksCheckCondition
implements SSRFNetHooksCheckCondition {
    @Override
    public boolean needsCheck(InetAddress address) {
        List<String> hostNames = InetAddressHostnameResolveStrategies.resolves(address);
        Iterator<String> iterator = CompatibleSsrfCheckerRegister.EXPIRING_SET.iterator();
        while (iterator.hasNext()) {
            String host = iterator.next();
            String formatJavaIp = IpFormatter.formatJavaIp(host);
            if (!hostNames.contains(host.toLowerCase()) && !hostNames.contains(formatJavaIp)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCustomThrowable() {
        return false;
    }
}

