/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.url.ssrf;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.permission.checker.SocketPermissionChecker;
import com.aliyun.securitysdk.rass.resource.DynamicResourceManager;
import com.aliyun.securitysdk.rass.util.IpAddressUtil;
import com.aliyun.securitysdk.url.SSRFChecker;
import com.aliyun.securitysdk.url.SSRFResult;
import com.aliyun.securitysdk.url.exception.SSRFUnsafeConnectionException;
import com.aliyun.securitysdk.url.model.SSRFMatcherEnum;
import com.aliyun.securitysdk.url.ssrf.policy.CompatibleSsrfCheckerRegister;
import com.aliyun.securitysdk.url.ssrf.policy.SsrfNetHookPolicyFactory;
import com.aliyun.securitysdk.url.ssrf.policy.SsrfNetHookStarter;
import com.aliyun.securitysdk.url.ssrf.strategy.InetAddressHostnameResolveStrategies;
import com.aliyun.securitysdk.util.AssertUtil;
import com.aliyun.securitysdk.util.UrlUtil;
import com.aliyun.securitysdk.util.http.HttpResult;
import com.aliyun.securitysdk.util.http.HttpSender;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import lombok.NonNull;

public class SSRFCheckerImpl
implements SSRFChecker {
    private static final Logger logger = SecurityLogManager.getLogger(SSRFCheckerImpl.class);
    private static final int DEFAULT_CHECK_TIMES = 0;
    private static final int DEFAULT_TIMEOUT = 200;
    private volatile String[] allowedProtocols = ALLOWED_PROTOCOLS;

    public void startNetHookWithThreadLocal() {
        CompatibleSsrfCheckerRegister.start();
    }

    public void startNetHookWithThreadLocal(String url) {
        SsrfNetHookStarter starter = SsrfNetHookPolicyFactory.getThreadLocalBasedSsrfNetHookStarter();
        this.startNetHooking(url, starter, false);
    }

    public void stopNetHookWithThreadLocal() {
        SsrfNetHookStarter starter = SsrfNetHookPolicyFactory.getThreadLocalBasedSsrfNetHookStarter();
        starter.stop();
    }

    public void startNetHookWithExpirationCache(String url) {
        this.startNetHooking(url, SsrfNetHookPolicyFactory.getExpiredCachedBasedSsrfNetHookStarter(), false);
    }

    public void startCustomNetHookWithExpirationCache(String url) {
        this.startNetHooking(url, SsrfNetHookPolicyFactory.getExpiredCachedBasedSsrfNetHookStarter(), true);
    }

    public boolean checkUrl(String url) {
        return this.checkUrl(url, 0, 200);
    }

    public boolean checkUrl(String url, int checkTimes) {
        return this.checkUrl(url, checkTimes, 200);
    }

    public boolean checkUrl(String url, int checkTimes, int timeout) {
        if (url == null || url.isEmpty()) {
            return false;
        }
        if (checkTimes <= 0) {
            checkTimes = 0;
        }
        try {
            URL realUrl = null;
            String realUrlString = url;
            for (int i = 0; i <= checkTimes; ++i) {
                URL redirectUrl;
                HttpResult redirectResult;
                if (!this.checkUrlWithoutConnection(realUrlString, false)) {
                    return false;
                }
                if (realUrl == null) {
                    realUrl = new URL(url);
                }
                if ((redirectResult = HttpSender.send(realUrl, timeout)) == null) {
                    return false;
                }
                if (!redirectResult.isRedirect()) {
                    return true;
                }
                String redirectUrlString = redirectResult.getUrl();
                realUrl = redirectUrl = new URL(redirectUrlString);
                realUrlString = redirectUrlString;
            }
        }
        catch (MalformedURLException me) {
            logger.warn("A malformed URL exception has occurred", (Throwable)me);
            return false;
        }
        catch (Exception e) {
            logger.warn("Error occurred when checking url " + url, (Throwable)e);
            return true;
        }
        return false;
    }

    public boolean checkUrlWithoutConnection(String url) {
        try {
            return this.checkUrlWithoutConnection(url, false, false);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return true;
        }
    }

    public boolean checkUrlWithoutConnection(String url, boolean isIpAllowed) {
        try {
            return this.checkUrlWithoutConnection(url, false, isIpAllowed);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return true;
        }
    }

    public SSRFResult checkUrlWithoutConnectionWithDetail(String url, boolean isIpAllowed) {
        try {
            return this.checkUrlWithoutConnection0(url, false, isIpAllowed);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return SSRFResult.ofSafe();
        }
    }

    public void resetAllowedProtocols(String[] allowedProtocols) {
        AssertUtil.checkArgument(allowedProtocols != null && allowedProtocols.length > 0, "The allowed protocols should not be null or empty.");
        this.allowedProtocols = allowedProtocols;
    }

    public void addCustomAllowedSubnetMasks(@NonNull SSRFMatcherEnum ssrfMatcherEnum, String ... matcherMasks) {
        if (ssrfMatcherEnum == null) {
            throw new NullPointerException("ssrfMatcherEnum is marked non-null but is null");
        }
        if (matcherMasks == null) {
            throw new NullPointerException("matcherMasks is marked non-null but is null");
        }
        DynamicResourceManager.getInstance((boolean)false).addSsrfRule(ssrfMatcherEnum.value(), matcherMasks);
    }

    public void removeCustomAllowedSubnetMasks(@NonNull SSRFMatcherEnum ssrfMatcherEnum, String ... matcherMasks) {
        if (ssrfMatcherEnum == null) {
            throw new NullPointerException("ssrfMatcherEnum is marked non-null but is null");
        }
        if (matcherMasks == null) {
            throw new NullPointerException("matcherMasks is marked non-null but is null");
        }
        DynamicResourceManager.getInstance((boolean)false).removeSsrfRule(ssrfMatcherEnum.value(), matcherMasks);
    }

    public List<String> listAllMasks(SSRFMatcherEnum ssrfMatcherEnum) {
        return DynamicResourceManager.getInstance((boolean)false).listSsrfRule(ssrfMatcherEnum.value());
    }

    public void configureMasks(SSRFMatcherEnum ssrfMatcherEnum, String ... matcherMasks) {
        DynamicResourceManager.getInstance((boolean)false).configureSsrfRule(ssrfMatcherEnum.value(), matcherMasks);
    }

    public boolean checkSSRF(String url) {
        if (url == null) {
            return false;
        }
        if (!this.checkprotocol(url)) {
            return false;
        }
        String host = UrlUtil.parseUrl(url, false);
        if (host == null) {
            return false;
        }
        return SSRFCheckerImpl.isTrusted(host);
    }

    static boolean isAllowedAddress(InetAddress inetAddress) {
        if (inetAddress == null) {
            return false;
        }
        String host = InetAddressHostnameResolveStrategies.resolve(inetAddress);
        if (host != null && !UrlUtil.validateHost(host)) {
            return false;
        }
        return SSRFCheckerImpl.checkHostAndInetAddress(host, inetAddress);
    }

    private void startNetHooking(String url, SsrfNetHookStarter starter, boolean isCustomThrowable) {
        if (url == null) {
            return;
        }
        if (!this.checkprotocol(url)) {
            logger.warn("ssrf attack, unsafe protocol for url: {}", (Object)url);
            throw new SSRFUnsafeConnectionException("[" + url + "]Unsafe protocol for url.");
        }
        String host = UrlUtil.parseUrl(url, false);
        if (host == null) {
            logger.warn("ssrf attack, host is null: {}", (Object)url);
            throw new SSRFUnsafeConnectionException("[" + url + "]The host is null.");
        }
        starter.setHost(host);
        starter.setCustomThrowable(isCustomThrowable);
        if (SSRFCheckerImpl.isTrusted(host)) {
            starter.start();
            return;
        }
        if (!UrlUtil.validateHost(host)) {
            logger.warn("ssrf attack, host not allowed: ", (Object)url);
            throw new SSRFUnsafeConnectionException("[" + url + "]The host is banned.");
        }
        String ipString = "";
        boolean isIPv6 = false;
        if (IpAddressUtil.isIpv4Address((String)host)) {
            ipString = IpAddressUtil.convertIpv4ToString((String)host);
        } else if (IpAddressUtil.isIpv6Address((String)host)) {
            ipString = IpAddressUtil.convertIpv6ToString((String)host);
            isIPv6 = true;
        }
        if (!SSRFCheckerImpl.checkHostAndIPString(host, ipString, isIPv6)) {
            logger.warn("ssrf attack, host not allowed: {}", (Object)url);
            throw new SSRFUnsafeConnectionException("[" + url + "]The host is banned.");
        }
        starter.start();
    }

    boolean checkUrlWithoutConnection(String url, boolean isHost, boolean isIpAllowed) {
        return this.checkUrlWithoutConnection0(url, isHost, isIpAllowed).isSafe();
    }

    SSRFResult checkUrlWithoutConnection0(String url, boolean isHost, boolean isIpAllowed) {
        if (url == null) {
            return SSRFResult.ofNotSafe();
        }
        if (!this.checkprotocol(url)) {
            return SSRFResult.ofNotSafe();
        }
        String host = UrlUtil.parseUrl(url, isHost);
        if (host == null) {
            return SSRFResult.ofNotSafe();
        }
        if (!isIpAllowed && IpAddressUtil.isIpAddress((String)host)) {
            return SSRFResult.ofNotSafe();
        }
        if (SSRFCheckerImpl.isTrusted(host)) {
            return SSRFResult.ofSafe();
        }
        if (!UrlUtil.validateHost(host)) {
            return SSRFResult.ofNotSafe();
        }
        return SSRFCheckerImpl.checkSSRFBannedAddress(host);
    }

    boolean checkprotocol(String url) {
        String theUrl = url.substring(0, Math.min(8, url.length())).toLowerCase();
        for (String protocol : this.allowedProtocols) {
            if (!theUrl.startsWith(protocol)) continue;
            return true;
        }
        return false;
    }

    private static SSRFResult checkSSRFBannedAddress(String host) {
        block5: {
            if (host == null) {
                return SSRFResult.ofNotSafe();
            }
            try {
                InetAddress[] addresses = InetAddress.getAllByName(host);
                if (addresses != null && addresses.length != 0) {
                    for (InetAddress address : addresses) {
                        if (SSRFCheckerImpl.checkHostAndInetAddress(host, address)) continue;
                        return SSRFResult.ofNotSafe((String)address.getHostAddress());
                    }
                    break block5;
                }
                return SSRFResult.ofNotSafe((String)"-1");
            }
            catch (UnknownHostException e) {
                return SSRFResult.ofNotSafe();
            }
        }
        return SSRFResult.ofSafe();
    }

    @Deprecated
    public void start() {
        this.startNetHookWithThreadLocal();
    }

    @Deprecated
    public void stop() {
        this.stopNetHookWithThreadLocal();
    }

    private static boolean isTrusted(String host) {
        for (SocketPermissionChecker checker : DynamicResourceManager.getInstance((boolean)false).getSsrfPermissionCheckers()) {
            if (!checker.isTrusted(host)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkHostAndInetAddress(String hostName, InetAddress address) {
        byte[] addressBytes = address.getAddress();
        if (addressBytes == null) {
            return false;
        }
        String ipString = IpAddressUtil.convertIpBytesToString((byte[])addressBytes);
        return SSRFCheckerImpl.checkHostAndIPString(hostName, ipString, address instanceof Inet6Address);
    }

    private static boolean checkHostAndIPString(String hostName, String ipString, boolean isIPv6) {
        hostName = hostName.toLowerCase();
        for (SocketPermissionChecker checker : DynamicResourceManager.getInstance((boolean)false).getSsrfPermissionCheckers()) {
            if (checker.checkHostAndIPString(hostName, ipString, isIPv6)) continue;
            return false;
        }
        return true;
    }
}

