/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.sensitive.entity;

import com.aliyun.securitysdk.sensitive.entity.SensitiveRule;
import com.aliyun.securitysdk.sensitive.exception.SensitiveRuleNotCorrectException;
import com.aliyun.securitysdk.sensitive.matcher.RegexUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class RuleWrapper {
    private List<SensitiveRule> rules = new ArrayList<SensitiveRule>();

    public RuleWrapper() {
    }

    public RuleWrapper(Map<String, Object> yamlData) throws SensitiveRuleNotCorrectException {
        ArrayList<SensitiveRule> rules = new ArrayList<SensitiveRule>();
        try {
            List rulesData = (List)yamlData.get("rules");
            if (rulesData != null) {
                for (Map ruleData : rulesData) {
                    SensitiveRule rule = new SensitiveRule();
                    rule.setName((String)ruleData.get("name"));
                    rule.setType((String)ruleData.get("type"));
                    rule.setKeyword((List)ruleData.get("keyword"));
                    rule.setDelimiters((List)ruleData.get("delimiters"));
                    rule.setValue((List)ruleData.get("value"));
                    rule.setWhiteRegex((Map)ruleData.get("whiteRegex"));
                    boolean isDefault = (Boolean)ruleData.get("default") != null && (Boolean)ruleData.get("default") != false;
                    rule.setDefaultRule(isDefault);
                    rules.add(rule);
                }
            }
        }
        catch (Exception e) {
            throw new SensitiveRuleNotCorrectException("Invalid rule format: " + e.getMessage(), (Throwable)e);
        }
        this.rules = rules;
    }

    public List<SensitiveRule> getRules() {
        return this.rules;
    }

    public void setRules(List<SensitiveRule> rules) {
        this.rules = rules;
    }

    public void addRule(SensitiveRule rule) {
        this.rules.add(rule);
    }

    public void mergeRules(RuleWrapper inRules) {
        List<SensitiveRule> rules = inRules.getRules();
        for (SensitiveRule rule : this.rules) {
            if (inRules.isRuleExist(rule.getName())) continue;
            rules.add(rule);
        }
        this.rules = rules;
    }

    public boolean isRuleExist(String ruleName) {
        for (SensitiveRule rule : this.rules) {
            if (!rule.getName().equals(ruleName)) continue;
            return true;
        }
        return false;
    }

    public SensitiveRule getRuleByName(String ruleName) {
        for (SensitiveRule rule : this.rules) {
            if (!rule.getName().equals(ruleName)) continue;
            return rule;
        }
        return null;
    }

    public void validate() throws SensitiveRuleNotCorrectException {
        for (SensitiveRule rule : this.rules) {
            try {
                rule.validate();
            }
            catch (Exception e) {
                throw new SensitiveRuleNotCorrectException(rule + "\n Rule validated fail: \n" + e.getMessage(), (Throwable)e);
            }
        }
    }

    public Map<String, Pattern> getRegexPatterns() {
        HashMap<String, Pattern> patterns = new HashMap<String, Pattern>();
        for (SensitiveRule rule : this.rules) {
            patterns.put(rule.getName(), RegexUtil.getRegexPattern(rule));
        }
        return patterns;
    }

    public Map<String, Pattern> getKeywordPatterns() {
        HashMap<String, Pattern> patterns = new HashMap<String, Pattern>();
        for (SensitiveRule rule : this.rules) {
            Pattern pattern = RegexUtil.getKeywordPattern(rule);
            if (pattern == null) continue;
            patterns.put(rule.getName(), pattern);
        }
        return patterns;
    }

    public Map<String, Pattern> getValuePatterns() {
        HashMap<String, Pattern> patterns = new HashMap<String, Pattern>();
        for (SensitiveRule rule : this.rules) {
            Pattern pattern = RegexUtil.getValuePattern(rule);
            if (pattern == null) continue;
            patterns.put(rule.getName(), pattern);
        }
        return patterns;
    }

    public Map<String, Pattern> getWhiteKeywordPatterns() {
        HashMap<String, Pattern> patterns = new HashMap<String, Pattern>();
        for (SensitiveRule rule : this.rules) {
            Pattern pattern = RegexUtil.getWhiteKeywordPattern(rule);
            if (pattern == null) continue;
            patterns.put(rule.getName(), pattern);
        }
        return patterns;
    }

    public Map<String, Pattern> getWhiteValuePatterns() {
        HashMap<String, Pattern> patterns = new HashMap<String, Pattern>();
        for (SensitiveRule rule : this.rules) {
            Pattern pattern = RegexUtil.getWhiteValuePattern(rule);
            if (pattern == null) continue;
            patterns.put(rule.getName(), pattern);
        }
        return patterns;
    }

    public void filterByNames(List<String> ruleNames) throws SensitiveRuleNotCorrectException {
        ArrayList<SensitiveRule> newRules = new ArrayList<SensitiveRule>();
        for (String ruleName : ruleNames) {
            boolean isExist = false;
            for (SensitiveRule rule : this.rules) {
                if (!rule.getName().equals(ruleName)) continue;
                newRules.add(rule);
                isExist = true;
                break;
            }
            if (isExist) continue;
            throw new SensitiveRuleNotCorrectException("Rule " + ruleName + " not exist!");
        }
        this.rules = newRules;
    }

    public void enableDefaultRules() {
        ArrayList<SensitiveRule> newRules = new ArrayList<SensitiveRule>();
        for (SensitiveRule rule : this.rules) {
            if (!rule.isDefaultRule()) continue;
            newRules.add(rule);
        }
        this.rules = newRules;
    }
}

