/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.sensitive;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.sensitive.SensitiveDataClient;
import com.aliyun.securitysdk.sensitive.entity.RuleWrapper;
import com.aliyun.securitysdk.sensitive.entity.SensitiveDataEnum;
import com.aliyun.securitysdk.sensitive.exception.SensitiveRuleNotCorrectException;
import com.aliyun.securitysdk.sensitive.mask.MaskUtil;
import com.aliyun.securitysdk.sensitive.matcher.MatchItem;
import com.aliyun.securitysdk.sensitive.matcher.MatchResult;
import com.aliyun.securitysdk.sensitive.matcher.RegexUtil;
import com.aliyun.securitysdk.sensitive.white.WhiteRegexUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class SensitiveDataClientImpl
extends SensitiveDataClient {
    private static final Logger logger = SecurityLogManager.getLogger(SensitiveDataClientImpl.class);
    private static final String DEFAULT_RULE_PATH = "sensitive/sensitiveRule.yaml";
    private static final int MAX_DATA_LENGTH = 65536;
    private static final Pattern backSlashPattern = Pattern.compile("\\\\+$", 2);
    private RuleWrapper ruleWrapper = null;
    private Map<String, Pattern> patterns;
    private Map<String, Pattern> keywordPatterns;
    private Map<String, Pattern> valuePatterns;
    private Map<String, Pattern> whiteKeywordPatterns;
    private Map<String, Pattern> whiteValuePatterns;

    public SensitiveDataClient createClient() throws SensitiveRuleNotCorrectException {
        SensitiveDataClientImpl client = new SensitiveDataClientImpl();
        RuleWrapper ruleWrapper = client.loadRulesFromFile(DEFAULT_RULE_PATH);
        ruleWrapper.enableDefaultRules();
        client.loadRegexPatterns(ruleWrapper);
        client.ruleWrapper = ruleWrapper;
        return client;
    }

    public SensitiveDataClient createClient(SensitiveDataEnum sensitiveDataEnum) throws SensitiveRuleNotCorrectException {
        SensitiveDataClientImpl client = new SensitiveDataClientImpl();
        RuleWrapper ruleWrapper = client.loadRulesFromFile(DEFAULT_RULE_PATH);
        switch (sensitiveDataEnum) {
            case EnableDefaultRules: {
                ruleWrapper.enableDefaultRules();
                break;
            }
        }
        client.loadRegexPatterns(ruleWrapper);
        client.ruleWrapper = ruleWrapper;
        return client;
    }

    public SensitiveDataClient createClient(List<String> ruleNames) throws SensitiveRuleNotCorrectException {
        SensitiveDataClientImpl client = new SensitiveDataClientImpl();
        RuleWrapper ruleWrapper = client.loadRulesFromFile(DEFAULT_RULE_PATH);
        ruleWrapper.filterByNames(ruleNames);
        client.loadRegexPatterns(ruleWrapper);
        client.ruleWrapper = ruleWrapper;
        return client;
    }

    public SensitiveDataClient createClient(String ruleFileName) throws SensitiveRuleNotCorrectException {
        SensitiveDataClientImpl client = new SensitiveDataClientImpl();
        RuleWrapper ruleWrapper = client.loadRulesFromFile(DEFAULT_RULE_PATH);
        RuleWrapper ruleWrapperIn = client.loadRulesFromFile(ruleFileName);
        ruleWrapper.mergeRules(ruleWrapperIn);
        client.loadRegexPatterns(ruleWrapper);
        client.ruleWrapper = ruleWrapper;
        return client;
    }

    public SensitiveDataClient createClient(String ruleFileName, List<String> ruleNames) throws SensitiveRuleNotCorrectException {
        SensitiveDataClientImpl client = new SensitiveDataClientImpl();
        RuleWrapper ruleWrapper = client.loadRulesFromFile(DEFAULT_RULE_PATH);
        RuleWrapper ruleWrapperIn = client.loadRulesFromFile(ruleFileName);
        ruleWrapper.mergeRules(ruleWrapperIn);
        ruleWrapper.filterByNames(ruleNames);
        client.loadRegexPatterns(ruleWrapper);
        client.ruleWrapper = ruleWrapper;
        return client;
    }

    private RuleWrapper loadRulesFromFile(String ruleFileName) throws SensitiveRuleNotCorrectException {
        InputStream inputStream = SensitiveDataClientImpl.class.getClassLoader().getResourceAsStream(ruleFileName);
        if (inputStream == null) {
            throw new SensitiveRuleNotCorrectException("SensitiveDataClient: " + ruleFileName + " file not found");
        }
        try {
            return this.loadRulesFromStream(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RuleWrapper loadRulesFromStream(InputStream inputStream) throws SensitiveRuleNotCorrectException, IOException {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        RuleWrapper ruleWrapper = null;
        try {
            Map yamlData = (Map)yaml.load(inputStream);
            ruleWrapper = new RuleWrapper(yamlData);
        }
        catch (Exception e) {
            throw new SensitiveRuleNotCorrectException(e.getMessage(), (Throwable)e);
        }
        finally {
            inputStream.close();
        }
        ruleWrapper.validate();
        return ruleWrapper;
    }

    private void loadRegexPatterns(RuleWrapper ruleWrapper) {
        this.patterns = ruleWrapper.getRegexPatterns();
        this.keywordPatterns = ruleWrapper.getKeywordPatterns();
        this.valuePatterns = ruleWrapper.getValuePatterns();
        this.whiteKeywordPatterns = ruleWrapper.getWhiteKeywordPatterns();
        this.whiteValuePatterns = ruleWrapper.getWhiteValuePatterns();
    }

    public MatchResult scanSensitivity(String data) {
        if (data.length() > 65536) {
            return new MatchResult();
        }
        MatchResult matchResult = new MatchResult();
        for (Map.Entry<String, Pattern> entry : this.patterns.entrySet()) {
            String ruleName = entry.getKey();
            Pattern pattern = entry.getValue();
            Matcher matcher = pattern.matcher(data);
            while (matcher.find()) {
                String keyword = null;
                try {
                    keyword = matcher.group("keyword");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String value = matcher.group("value");
                if (WhiteRegexUtil.isInWhiteList(keyword, this.whiteKeywordPatterns.get(ruleName), value, this.whiteValuePatterns.get(ruleName))) continue;
                MatchItem matchItem = new MatchItem();
                matchItem.setKeyword(keyword);
                matchItem.setValue(value);
                matchItem.setRuleName(ruleName);
                matchResult.addItem(matchItem);
            }
        }
        return matchResult;
    }

    public MatchResult scanSensitivity(Map<String, Object> objectMap) {
        MatchResult matchResult = new MatchResult();
        for (Map.Entry<String, Object> entry : objectMap.entrySet()) {
            String keyword = entry.getKey();
            Object value = entry.getValue();
            matchResult.addAll(this.scanSensitiveObject(keyword, value));
        }
        return matchResult;
    }

    private MatchResult scanSensitiveObject(String keyword, Object object) {
        MatchResult matchResult;
        block5: {
            block6: {
                block4: {
                    matchResult = new MatchResult();
                    if (!(object instanceof String)) break block4;
                    if (keyword == null) {
                        return null;
                    }
                    String value = (String)object;
                    for (String ruleName : this.patterns.keySet()) {
                        if (WhiteRegexUtil.isInWhiteList(keyword, this.whiteKeywordPatterns.get(ruleName), value, this.whiteValuePatterns.get(ruleName)) || !RegexUtil.isItemMatchPattern(keyword, this.keywordPatterns.get(ruleName)) || !RegexUtil.isItemMatchPattern((String)object, this.valuePatterns.get(ruleName))) continue;
                        MatchItem matchItem = new MatchItem();
                        matchItem.setKeyword(keyword);
                        matchItem.setValue(value);
                        matchItem.setRuleName(ruleName);
                        matchResult.addItem(matchItem);
                    }
                    break block5;
                }
                if (!(object instanceof Map)) break block6;
                Map map = (Map)object;
                for (Map.Entry entry : map.entrySet()) {
                    if (!(entry.getKey() instanceof String)) continue;
                    String newKey = (String)entry.getKey();
                    MatchResult innerResult = this.scanSensitiveObject(newKey, entry.getValue());
                    matchResult.addAll(innerResult);
                }
                break block5;
            }
            if (!(object instanceof List)) break block5;
            List objList = (List)object;
            for (Object obj : objList) {
                matchResult.addAll(this.scanSensitiveObject(null, obj));
            }
        }
        return matchResult;
    }

    public String maskSensitivity(String data) {
        if (data.length() > 65536) {
            return data;
        }
        StringBuffer result = new StringBuffer();
        for (Map.Entry<String, Pattern> entry : this.patterns.entrySet()) {
            String ruleName = entry.getKey();
            Pattern pattern = entry.getValue();
            boolean findMatch = false;
            Matcher matcher = pattern.matcher(data);
            while (matcher.find()) {
                String keyword = null;
                try {
                    keyword = matcher.group("keyword");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String value = matcher.group("value");
                if (WhiteRegexUtil.isInWhiteList(keyword, this.whiteKeywordPatterns.get(ruleName), value, this.whiteValuePatterns.get(ruleName))) continue;
                Matcher m = backSlashPattern.matcher(value);
                value = m.replaceAll("");
                String maskedValue = MaskUtil.maskValue(value);
                String replacement = MaskUtil.getReplacement(keyword, maskedValue, matcher);
                if (m.find()) {
                    replacement = replacement + m.group();
                }
                matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
                findMatch = true;
            }
            if (!findMatch) continue;
            matcher.appendTail(result);
            data = result.toString();
            result.setLength(0);
        }
        return data;
    }

    public Map<String, Object> maskSensitivity(Map<String, Object> objectMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : objectMap.entrySet()) {
            String keyword = entry.getKey();
            Object value = entry.getValue();
            Object obj = this.maskSensitiveObject(keyword, value);
            resultMap.put(keyword, obj);
        }
        return resultMap;
    }

    private Object maskSensitiveObject(String keyword, Object object) {
        if (object instanceof String) {
            if (keyword == null) {
                return object;
            }
            String processValue = (String)object;
            for (String ruleName : this.patterns.keySet()) {
                if (WhiteRegexUtil.isInWhiteList(keyword, this.whiteKeywordPatterns.get(ruleName), processValue, this.whiteValuePatterns.get(ruleName)) || !RegexUtil.isItemMatchPattern(keyword, this.keywordPatterns.get(ruleName)) || !RegexUtil.isItemMatchPattern((String)object, this.valuePatterns.get(ruleName))) continue;
                processValue = MaskUtil.maskValue((String)object);
                break;
            }
            return processValue;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                String newKey = (String)entry.getKey();
                Object newValue = this.maskSensitiveObject(newKey, entry.getValue());
                newMap.put(newKey, newValue);
            }
            if (newMap.isEmpty()) {
                return map;
            }
            return newMap;
        }
        if (object instanceof List) {
            List objList = (List)object;
            ArrayList<Object> newObjList = new ArrayList<Object>();
            for (Object obj : objList) {
                newObjList.add(this.maskSensitiveObject(null, obj));
            }
            return newObjList;
        }
        return object;
    }
}

