/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.ql;

import com.aliyun.securitysdk.ql.SLSQueryException;

public class SLSQueryTokenizer {
    private static final String delimiters = " \t\n\r\f";
    private final String str;
    private final int maxPosition;
    private int currentPosition = 0;
    private int newPosition;
    private char maxDelimCodePoint;

    public SLSQueryTokenizer(String query) {
        this.str = query;
        this.maxPosition = null == query ? 0 : query.length();
        this.newPosition = -1;
        this.setMaxDelimCodePoint();
    }

    private void setMaxDelimCodePoint() {
        char m = '\u0000';
        for (int i = 0; i < delimiters.length(); ++i) {
            char c = delimiters.charAt(i);
            if (m >= c) continue;
            m = c;
        }
        this.maxDelimCodePoint = m;
    }

    private int skipDelimiters(int startPos) {
        char c;
        int position;
        for (position = startPos; position < this.maxPosition && (c = this.str.charAt(position)) <= this.maxDelimCodePoint && delimiters.indexOf(c) >= 0; ++position) {
        }
        return position;
    }

    private int scanString(int startPos) throws SLSQueryException {
        int position = startPos;
        block4: while (position < this.maxPosition) {
            char c = this.str.charAt(position);
            switch (c) {
                case '\\': {
                    if (++position >= this.maxPosition) {
                        throw new SLSQueryException("syntax error: unexpected \\");
                    }
                    ++position;
                    continue block4;
                }
                case '\"': {
                    return position + 1;
                }
            }
            ++position;
        }
        throw new SLSQueryException("unclosed quotation mark");
    }

    private int scanToken(int startPos) throws SLSQueryException {
        char c;
        int position = startPos;
        while (position < this.maxPosition && ((c = this.str.charAt(position)) > this.maxDelimCodePoint || delimiters.indexOf(c) < 0)) {
            boolean breakLoop = false;
            switch (c) {
                case '(': 
                case ')': 
                case '[': 
                case ']': 
                case '|': {
                    breakLoop = true;
                    break;
                }
                case '\\': {
                    if (++position >= this.maxPosition) {
                        throw new SLSQueryException("syntax error: unexpected \\");
                    }
                    ++position;
                    break;
                }
                case '\"': {
                    position = this.scanString(position + 1);
                    break;
                }
                default: {
                    ++position;
                }
            }
            if (!breakLoop) continue;
            break;
        }
        if (startPos == position) {
            ++position;
        }
        return position;
    }

    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    public String nextToken() throws SLSQueryException {
        this.currentPosition = this.newPosition >= 0 ? this.newPosition : this.skipDelimiters(this.currentPosition);
        this.newPosition = -1;
        int start = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        return this.str.substring(start, this.currentPosition);
    }

    public void reset() {
        this.currentPosition = 0;
        this.newPosition = -1;
    }
}

