/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.ql;

import com.aliyun.securitysdk.ql.BracketChecker;
import com.aliyun.securitysdk.ql.QLTool;
import com.aliyun.securitysdk.ql.SLSQueryException;
import com.aliyun.securitysdk.util.CharMasks;
import com.aliyun.securitysdk.util.StringUtils;

public class QLToolImpl
implements QLTool {
    private static final int SIZE = 128;
    private static final CharMasks MASKS = new CharMasks(128){
        {
            this.addCharToMasks("\\\u0000\n\r'\"");
        }
    };
    private static final boolean[] ESCAPE_CMD_MASKS = MASKS.getMasks();
    private static final char BOUND = '\u001a';
    private static final String ESCAPED_BOUND = "0x1a";
    private static final CharMasks FILTER_TRIM_MASKS = QLToolImpl.createCharMasks(false);
    private static final CharMasks FILTER_TRIM_ORDER_BY_MASKS = QLToolImpl.createCharMasks(true);

    public String buildSlsQuery(String systemQuery, String userQuery) throws SLSQueryException {
        if (StringUtils.isBlank(systemQuery)) {
            throw new SLSQueryException("system query can not be empty");
        }
        if (systemQuery.trim().equals("*")) {
            throw new SLSQueryException("system query can not be *");
        }
        if (StringUtils.isBlank(userQuery = userQuery.replace("\\", ""))) {
            return systemQuery;
        }
        BracketChecker checker = new BracketChecker(userQuery);
        checker.checkWhetherBracketMatches();
        return "( " + systemQuery + " ) and ( " + userQuery + " )";
    }

    public String buildSlsQuery(String systemQuery, String userQuery, String sql, Object[] params) {
        throw new RuntimeException("Not Implemented");
    }

    public String mysqlRealEscapeString(String unescapedString) {
        return QLToolImpl.filterStatically(unescapedString);
    }

    private static CharMasks createCharMasks(final boolean forOrderBy) {
        return new CharMasks(128){
            {
                int i;
                super(size);
                for (i = 48; i < 58; ++i) {
                    this.addCharToMasks((char)i);
                }
                for (i = 65; i < 91; ++i) {
                    this.addCharToMasks((char)i);
                }
                for (i = 97; i < 123; ++i) {
                    this.addCharToMasks((char)i);
                }
                this.addCharToMasks("_-.");
                if (forOrderBy) {
                    this.addCharToMasks(" ");
                    this.addCharToMasks(",");
                }
            }
        };
    }

    public String trimSql(String sql) {
        return QLToolImpl.trimSqlStatically(sql);
    }

    public String trimSql4OrderBy(String sql) {
        return QLToolImpl.trimSqlStatically(sql, true);
    }

    public String escapeSlsSql(String unescapedString) {
        if (unescapedString == null) {
            return null;
        }
        return unescapedString.replace("'", "''");
    }

    static String trimSqlStatically(String columnName) {
        return QLToolImpl.trimSqlStatically(columnName, false);
    }

    static String trimSqlStatically(String columnName, boolean forOrderBy) {
        if (columnName == null || columnName.isEmpty()) {
            return columnName;
        }
        CharMasks masks = forOrderBy ? FILTER_TRIM_ORDER_BY_MASKS : FILTER_TRIM_MASKS;
        StringBuilder sb = new StringBuilder();
        int lastPos = 0;
        for (int i = 0; i < columnName.length(); ++i) {
            char c = columnName.charAt(i);
            if (c >= '\u4e00' && c <= '\u9fbb' || c < '\u0080' && masks.getMasks()[c]) continue;
            sb.append(columnName, lastPos, i);
            lastPos = i + 1;
        }
        return sb.append(columnName.substring(lastPos)).toString();
    }

    static String filterStatically(String sql) {
        if (sql == null || sql.isEmpty()) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        int lastPos = 0;
        for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (c < '\u0080' && ESCAPE_CMD_MASKS[c]) {
                sb.append(sql, lastPos, i);
                sb.append('\\').append(c);
                lastPos = i + 1;
                continue;
            }
            if (c != '\u001a') continue;
            sb.append(sql, lastPos, i).append(ESCAPED_BOUND);
            lastPos = i + 1;
        }
        return sb.append(sql.substring(lastPos)).toString();
    }
}

