/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.mask.model.guest;

import com.aliyun.securitysdk.mask.DataType;
import com.aliyun.securitysdk.mask.model.guest.AbstractGuestMaskModel;
import com.aliyun.securitysdk.util.SensitiveDataUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class QuanxiSubjectGuestMaskModel
extends AbstractGuestMaskModel {
    private static final String[] blackList = new String[]{"\u963f\u91cc", "\u8682\u8681", "\u997f\u4e86", "\u9ad8\u5fb7", "\u7f51\u5546", "\u53e3\u7891", "\u76d2\u9a6c", "\u9ad8\u5fb7", "\u74f4\u7f8a", "\u901a\u4e49", "\u6dd8\u5b9d", "\u5929\u732b", "\u83dc\u9e1f", "\u9489\u9489", "\u98de\u732a", "\u95f2\u9c7c", "\u652f\u4ed8", "\u8fbe\u6469", "\u5e73\u5934", "\u4f18\u9177"};
    private static final Set<String> blackListSet = new HashSet<String>(Arrays.asList(blackList));

    @Override
    public DataType getDataType() {
        return DataType.HW_QUANXI_SUBJECT;
    }

    @Override
    public String doMask(String input) {
        if (input == null) {
            return null;
        }
        if (input.isEmpty()) {
            return "";
        }
        if (input.length() == 1) {
            return "*";
        }
        if (input.length() <= 3) {
            return SensitiveDataUtil.customizeIntraMark(input, 0, 1);
        }
        String ret = SensitiveDataUtil.customizeIntraMark(input, 2, 1);
        String firstTwo = ret.substring(0, 2);
        if (blackListSet.contains(firstTwo)) {
            return "**" + ret.substring(2);
        }
        return ret;
    }
}

