/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.parser;

import com.aliyun.securitysdk.jdbc.JdbcURLException;
import com.aliyun.securitysdk.jdbc.JdbcURLUnsafeException;
import com.aliyun.securitysdk.jdbc.parser.SemicolonSeparatedUrlParser;
import java.util.regex.Pattern;

public class UCanAccessUrlParser
extends SemicolonSeparatedUrlParser {
    private static final Pattern DATABASE_PATTERN = Pattern.compile("^[a-zA-Z0-9_\\-\\.:\\/]+$");

    @Override
    public Pattern getDatabasePattern() {
        return DATABASE_PATTERN;
    }

    @Override
    public void parseUrlWithoutScheme(String url) throws JdbcURLException {
        int paramIndex = url.indexOf(59);
        if (paramIndex > -1) {
            this.database = url.substring(0, paramIndex);
            this.parseProperties(url.substring(paramIndex + 1));
        } else {
            this.database = url;
        }
        if (this.database == null || this.database.isEmpty() || !this.getDatabasePattern().matcher(this.database).matches()) {
            throw new JdbcURLUnsafeException("invalid database in url: " + this.database);
        }
    }

    @Override
    public String toString() {
        return this.scheme + "//" + this.database + (this.properties.isEmpty() ? "" : ";" + this.propertiesToString());
    }
}

