/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.parser;

import com.aliyun.securitysdk.jdbc.JdbcURLException;
import com.aliyun.securitysdk.jdbc.JdbcURLUnsafeException;
import com.aliyun.securitysdk.jdbc.parser.DefaultUrlParser;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RedshiftParser
extends DefaultUrlParser {
    private static final Pattern URL_PATTERN = Pattern.compile("(iam:)?//([^:/?]+)(:([^/?]*))?(/([^?;]*))?([?;](.*))?");
    private static final Pattern URL_DATABASE_PATTERN = Pattern.compile("^[a-zA-Z0-9_\\-\\./%]+$");
    protected static final Pattern HOST_PATTERN = Pattern.compile("^[a-zA-Z0-9_\\-\\.:\\[\\],]+$");
    private boolean iamAuth = false;
    private String port;

    @Override
    protected void parseUrlWithoutScheme(String urlSecondPart) throws JdbcURLException {
        String[] args;
        String url;
        String urlServer = url = this.getInitialUrl();
        String urlArgs = "";
        int qPos = url.indexOf(63);
        if (qPos != -1) {
            urlServer = url.substring(0, qPos);
            urlArgs = url.substring(qPos + 1);
        } else {
            qPos = url.indexOf(59);
            if (qPos != -1) {
                urlServer = url.substring(0, qPos);
                urlArgs = url.substring(qPos + 1);
            }
        }
        urlServer = urlServer.substring("jdbc:redshift:".length());
        if (urlServer.startsWith("iam:")) {
            String subname = urlServer;
            Matcher matcher = URL_PATTERN.matcher(subname);
            if (!matcher.matches()) {
                throw new JdbcURLUnsafeException("illegal redshift url: " + this.getInitialUrl());
            }
            this.iamAuth = matcher.group(1) != null;
            this.host = matcher.group(2);
            this.port = matcher.group(4);
            this.database = matcher.group(6);
            String queryString = matcher.group(8);
            if (this.database != null && !URL_DATABASE_PATTERN.matcher(this.database).matches()) {
                throw new JdbcURLUnsafeException("invalid database: " + this.database + " url: " + this.getInitialUrl());
            }
            if (queryString != null) {
                urlArgs = queryString;
            }
        } else {
            String[] addresses;
            int slash = (urlServer = urlServer.substring(2)).indexOf(47);
            if (slash == -1) {
                throw new JdbcURLUnsafeException("illegal redshift url: " + this.getInitialUrl());
            }
            this.database = RedshiftParser.urlDecode(urlServer.substring(slash + 1));
            if (!this.database.isEmpty() && !this.getDatabasePattern().matcher(this.database).matches()) {
                throw new JdbcURLUnsafeException("invalid database: " + this.database + " url: " + this.getInitialUrl());
            }
            this.host = urlServer.substring(0, slash);
            if (!HOST_PATTERN.matcher(this.host).matches()) {
                throw new JdbcURLUnsafeException("invalid host: " + this.host + " url:" + this.getInitialUrl());
            }
            String[] stringArray = addresses = this.host.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String address = stringArray[i];
                int portIdx = address.lastIndexOf(58);
                if (portIdx == -1 || address.lastIndexOf(93) >= portIdx) continue;
                String portStr = address.substring(portIdx + 1);
                try {
                    int port = Integer.parseInt(portStr);
                    if (port >= 1 && port <= 65535) continue;
                    throw new JdbcURLUnsafeException("invalid port, url: " + this.getInitialUrl());
                }
                catch (NumberFormatException ignore) {
                    throw new JdbcURLUnsafeException("invalid port, url: " + this.getInitialUrl());
                }
            }
        }
        for (String token : args = urlArgs.split("[;&?]")) {
            if (token.isEmpty()) continue;
            int pos = token.indexOf(61);
            if (pos == -1) {
                this.properties.put(token, "");
                continue;
            }
            this.properties.put(token.substring(0, pos), RedshiftParser.urlDecode(token.substring(pos + 1)));
        }
    }

    @Override
    protected String propertiesToString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry entry : this.properties.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(";");
            }
            sb.append((String)entry.getKey());
            sb.append("=");
            sb.append(RedshiftParser.urlEncode((String)entry.getValue()));
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder url = new StringBuilder();
        url.append("jdbc:redshift:");
        if (this.iamAuth) {
            url.append("iam:");
        }
        url.append("//");
        url.append(this.host);
        if (this.port != null && !this.port.isEmpty()) {
            url.append(":").append(this.port);
        }
        url.append("/");
        if (this.database != null && !this.database.isEmpty()) {
            if (this.iamAuth) {
                url.append(this.database);
            } else {
                url.append(RedshiftParser.urlEncode(this.database));
            }
        }
        if (!this.properties.isEmpty()) {
            url.append(";");
            url.append(this.propertiesToString());
        }
        return url.toString();
    }

    private static String urlDecode(String encoded) {
        try {
            return URLDecoder.decode(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException ignored) {
            return encoded;
        }
    }

    private static String urlEncode(String plain) {
        try {
            return URLEncoder.encode(plain, "UTF-8");
        }
        catch (UnsupportedEncodingException ignored) {
            return plain;
        }
    }
}

