/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.parser;

import com.aliyun.securitysdk.jdbc.parser.DefaultUrlParser;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.regex.Pattern;

public class PostgresParser
extends DefaultUrlParser {
    private static final Pattern DATABASE_PATTERN = Pattern.compile("^[a-zA-Z0-9_\\-\\.\\p{script=Han}$@]+$");

    @Override
    protected Pattern getDatabasePattern() {
        return DATABASE_PATTERN;
    }

    @Override
    protected void parseProperties(String urlParameters) {
        if (urlParameters != null && !urlParameters.isEmpty()) {
            String[] parameters;
            for (String parameter : parameters = urlParameters.split(this.getParamSeparator())) {
                int pos = parameter.indexOf(61);
                if (pos == -1) {
                    if (this.properties.containsKey(parameter)) continue;
                    this.properties.put(parameter.trim(), "");
                    continue;
                }
                this.properties.put(parameter.substring(0, pos).trim(), PostgresParser.urlDecode(parameter.substring(pos + 1).trim()));
            }
        }
    }

    @Override
    protected String propertiesToString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry entry : this.properties.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(this.getParamSeparator());
            }
            sb.append((String)entry.getKey());
            sb.append("=");
            sb.append(PostgresParser.urlEncode((String)entry.getValue()));
        }
        return sb.toString();
    }

    private static String urlDecode(String encoded) {
        try {
            return URLDecoder.decode(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException ignored) {
            return encoded;
        }
    }

    private static String urlEncode(String plain) {
        try {
            return URLEncoder.encode(plain, "UTF-8");
        }
        catch (UnsupportedEncodingException ignored) {
            return plain;
        }
    }
}

