/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.parser;

import com.aliyun.securitysdk.jdbc.JdbcURLException;
import com.aliyun.securitysdk.jdbc.JdbcURLUnsafeException;
import com.aliyun.securitysdk.jdbc.UrlParser;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultUrlParser
implements UrlParser {
    protected String initialUrl;
    protected String scheme;
    protected String host;
    protected int port;
    protected String database;
    protected Map<String, String> properties = new HashMap<String, String>();
    protected static final Pattern HOST_PATTERN = Pattern.compile("^[a-zA-Z0-9_\\-\\.:\\[\\],]+$");
    protected static final Pattern URL_PARAMETER = Pattern.compile("(\\/([^\\?]*))?(\\?(.+))*", 32);
    private static final Pattern DATABASE_PATTERN = Pattern.compile("^[a-zA-Z0-9_\\-\\.\\p{script=Han}$]+$");
    private final String PARAM_MARKER = "?";
    private final String PARAM_SEPARATOR = "&";
    private Pattern hostPatternOverride = null;

    public String getInitialUrl() {
        return this.initialUrl;
    }

    protected String getParamSeparator() {
        return "&";
    }

    protected String getParamMarker() {
        return "?";
    }

    protected Pattern getUrlParameterPattern() {
        return URL_PARAMETER;
    }

    protected Pattern getDatabasePattern() {
        return DATABASE_PATTERN;
    }

    protected Pattern getHostPattern() {
        return this.hostPatternOverride == null ? HOST_PATTERN : this.hostPatternOverride;
    }

    public void setHostPattern(Pattern pattern) {
        this.hostPatternOverride = pattern;
    }

    public void parse(String url) throws JdbcURLException {
        this.initialUrl = url;
        int separator = url.indexOf("//");
        if (separator == -1) {
            throw new JdbcURLUnsafeException("url parsing error : '//' is not present in the url " + url);
        }
        this.scheme = url.substring(0, separator);
        String urlSecondPart = url.substring(separator + 2);
        this.parseUrlWithoutScheme(urlSecondPart);
    }

    protected void parseUrlWithoutScheme(String urlSecondPart) throws JdbcURLException {
        String additionalParameters;
        String hostAddressesString;
        int paramIndex;
        int dbIndex = urlSecondPart.indexOf("/");
        if (dbIndex < (paramIndex = urlSecondPart.indexOf(this.getParamMarker())) && dbIndex < 0 || dbIndex > paramIndex && paramIndex > -1) {
            hostAddressesString = urlSecondPart.substring(0, paramIndex);
            additionalParameters = urlSecondPart.substring(paramIndex);
        } else if (dbIndex < paramIndex || dbIndex > paramIndex) {
            hostAddressesString = urlSecondPart.substring(0, dbIndex);
            additionalParameters = urlSecondPart.substring(dbIndex);
        } else {
            hostAddressesString = urlSecondPart;
            additionalParameters = null;
        }
        this.parseHost(hostAddressesString);
        this.parseAdditionalParameter(additionalParameters);
    }

    protected void parseHost(String hostAddressesString) throws JdbcURLException {
        String portString;
        String hostString;
        int portIndex = hostAddressesString.lastIndexOf(":");
        int bracketIndex = hostAddressesString.indexOf("]");
        if (bracketIndex > -1 && bracketIndex < portIndex || portIndex > -1 && hostAddressesString.indexOf(":") == portIndex) {
            hostString = hostAddressesString.substring(0, portIndex);
            portString = hostAddressesString.substring(portIndex + 1);
        } else {
            hostString = hostAddressesString;
            portString = null;
        }
        if (!this.getHostPattern().matcher(hostString).matches()) {
            throw new JdbcURLUnsafeException("invalid host '" + hostString + "' in url: " + hostAddressesString);
        }
        this.host = hostString;
        if (portString != null && !portString.isEmpty()) {
            try {
                this.port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                throw new JdbcURLUnsafeException("invalid host " + hostAddressesString + " in url: " + this.initialUrl);
            }
            if (this.port < 0 || this.port > 65535) {
                throw new JdbcURLUnsafeException("invalid port " + portString + " in url: " + this.initialUrl);
            }
        } else {
            this.port = -1;
        }
    }

    protected void parseAdditionalParameter(String additionalParameters) throws JdbcURLException {
        if (additionalParameters != null) {
            Matcher matcher = this.getUrlParameterPattern().matcher(additionalParameters);
            boolean unused = matcher.find();
            this.database = matcher.group(2);
            this.parseProperties(matcher.group(4));
            if (this.database != null && this.database.isEmpty()) {
                this.database = null;
            }
        } else {
            this.database = null;
        }
        if (this.database != null && !this.getDatabasePattern().matcher(this.database).matches()) {
            throw new JdbcURLUnsafeException("invalid database in url: " + this.database);
        }
    }

    protected void parseProperties(String urlParameters) {
        if (urlParameters != null && !urlParameters.isEmpty()) {
            String[] parameters;
            for (String parameter : parameters = urlParameters.split(this.getParamSeparator())) {
                int pos = parameter.indexOf(61);
                if (pos == -1) {
                    if (this.properties.containsKey(parameter)) continue;
                    this.properties.put(parameter.trim(), "");
                    continue;
                }
                this.properties.put(parameter.substring(0, pos).trim(), parameter.substring(pos + 1).trim());
            }
        }
    }

    protected String propertiesToString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(this.getParamSeparator());
            }
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    public String toString() {
        return this.scheme + "//" + this.host + (this.port > -1 ? ":" + this.port : "") + (this.database != null ? "/" + this.database : "") + (this.properties.isEmpty() ? "" : this.getParamMarker() + this.propertiesToString());
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getPARAM_MARKER() {
        return this.PARAM_MARKER;
    }

    public String getPARAM_SEPARATOR() {
        return this.PARAM_SEPARATOR;
    }

    public Pattern getHostPatternOverride() {
        return this.hostPatternOverride;
    }
}

