/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.filters;

import com.aliyun.securitysdk.jdbc.UrlParser;
import com.aliyun.securitysdk.jdbc.filters.DefaultFilter;
import com.aliyun.securitysdk.jdbc.parser.MySQLUrlParser;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class MySQLFilter
extends DefaultFilter {
    private Set<String> innerAcceptedSchemes = new HashSet<String>(Arrays.asList("jdbc:mysql:", "jdbc:mariadb:", "jdbc:gbase:", "jdbc:oceanbase:", "jdbc:mysql2:", "jdbc:mysql+srv:", "jdbc:mysql:loadbalance:", "jdbc:mysql:replication:", "jdbc:mysql:failover:", "jdbc:mariadb:loadbalance:", "jdbc:mariadb:replication:", "jdbc:mariadb:failover:", "jdbc:oceanbase:loadbalance:", "jdbc:oceanbase:replication:", "jdbc:oceanbase:failover:", "jdbc:mysql+srv:loadbalance:", "jdbc:mysql+srv:replication:", "mysqlx:", "mysqlx+srv:", "jdbc:mariadb:sequential:", "jdbc:mariadb:aurora:"));
    private Set<String> acceptedSchemes = null;
    private static final Map<String, Pattern> propertyPatterns = new HashMap<String, Pattern>();
    private Set<String> acceptedPropertyKeys = new HashSet<String>(Arrays.asList("rewriteBatchedStatements", "enabledTLSProtocols", "maxReconnects", "useCompression", "maxAllowedPacket", "useCursorFetch", "useServerPrepStmts", "generateSimpleParameterMetadata", "connectionCollation", "yearIsDateType", "unicode", "allowPublicKeyRetrieval", "transformedBitIsBoolean", "useTimezone", "useLegacyDatetimeCode", "autoReconnect", "useLocalTransactionState", "allowMultiQueries", "useConfigs", "useUnicode", "initialTimeout", "failOverReadOnly", "defaultFetchSize", "com.mysql.jdbc.faultInjection.serverCharsetIndex", "requireSSL", "noAccessToProcedureBodies", "nullCatalogMeansCurrent", "user", "useJDBCCompliantTimezoneShift", "characterEncoding", "useOldAliasMetadataBehavior", "autoReconnectForPools", "useAffectedRows", "tinyInt1isBit", "zeroDateTimeBehavior", "useLocalSessionState", "serverTimezone", "useSSL", "createDatabaseIfNotExist", "com.mysql.cj.testsuite.faultInjection.serverCharsetIndex", "characterset", "failOverReadOnly", "verifyServerCertificate", "useInformationSchema", "sessionVariables", "socketTimeout", "connectTimeout", "netTimeoutForStreamingResults", "sslMode", "dontTrackOpenResources", "password"));
    private Set<String> propertyKeyWhiteList = new HashSet<String>(Arrays.asList("user", "username", "pass", "password", "sessionVariables"));

    @Override
    public UrlParser getUrlParser() {
        return new MySQLUrlParser();
    }

    @Override
    public boolean acceptURL(String url) {
        if (url == null) {
            return false;
        }
        String lowerUrl = url.toLowerCase();
        return (lowerUrl.startsWith("jdbc:mysql") || lowerUrl.startsWith("jdbc:mariadb") || lowerUrl.startsWith("jdbc:gbase") || lowerUrl.startsWith("jdbc:oceanbase") || lowerUrl.startsWith("mysqlx")) && !lowerUrl.startsWith("jdbc:mysql:fabric:");
    }

    @Override
    protected Map<String, Pattern> getPropertyPatterns() {
        return propertyPatterns;
    }

    @Override
    public void filterProperties(UrlParser parser) {
        super.filterProperties(parser);
        Map properties = parser.getProperties();
        properties.put("allowLoadLocalInfile", "false");
        if (!parser.getInitialUrl().startsWith("jdbc:gbase:")) {
            properties.put("allowLocalInfile", "false");
        }
        properties.put("allowUrlInLocalInfile", "false");
        properties.put("autoDeserialize", "false");
    }

    public Set<String> getInnerAcceptedSchemes() {
        return this.innerAcceptedSchemes;
    }

    public void setInnerAcceptedSchemes(Set<String> innerAcceptedSchemes) {
        this.innerAcceptedSchemes = innerAcceptedSchemes;
    }

    @Override
    public Set<String> getAcceptedSchemes() {
        return this.acceptedSchemes;
    }

    public void setAcceptedSchemes(Set<String> acceptedSchemes) {
        this.acceptedSchemes = acceptedSchemes;
    }

    @Override
    public Set<String> getAcceptedPropertyKeys() {
        return this.acceptedPropertyKeys;
    }

    @Override
    public void setAcceptedPropertyKeys(Set<String> acceptedPropertyKeys) {
        this.acceptedPropertyKeys = acceptedPropertyKeys;
    }

    @Override
    public Set<String> getPropertyKeyWhiteList() {
        return this.propertyKeyWhiteList;
    }

    @Override
    public void setPropertyKeyWhiteList(Set<String> propertyKeyWhiteList) {
        this.propertyKeyWhiteList = propertyKeyWhiteList;
    }

    static {
        propertyPatterns.put("enabledTLSProtocols".toLowerCase(), Pattern.compile("^[a-zA-Z0-9_\\-.,]+$"));
        propertyPatterns.put("servertimezone", Pattern.compile("^[a-zA-Z0-9_\\-.:\\[\\]/+%]+$"));
    }
}

