/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.filters;

import com.aliyun.securitysdk.jdbc.UrlParser;
import com.aliyun.securitysdk.jdbc.filters.DefaultFilter;
import com.aliyun.securitysdk.jdbc.parser.LindormLikeUrlParser;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class LindormFilter
extends DefaultFilter {
    protected Set<String> acceptedSchemes = new HashSet<String>();
    protected Set<String> internalAcceptedSchemes = new HashSet<String>(Arrays.asList("jdbc:lindorm:table:", "jdbc:lindorm:search:", "jdbc:lindorm:phoenix:", "jdbc:lindorm:analytics:", "jdbc:lindorm:tsdb:"));
    private Set<String> acceptedPropertyKeys = new HashSet<String>(Arrays.asList("schema", "timeZone", "url", "serialization", "authentication", "avatica_user", "avatica_password", "hostname_verification", "retryWhenMissConnection", "avatica.statement.retries", "user", "username", "password", "database", "failover", "maxRetries", "interval", "maxDelay", "lindorm.tsdb.driver.connect.timeout", "lindorm.tsdb.driver.connection.request.timeout", "lindorm.tsdb.driver.socket.timeout", "lindorm.tsdb.driver.http.compression"));
    private Set<String> propertyKeyWhiteList = new HashSet<String>(Arrays.asList("url", "timeZone", "avatica_password", "avatica_user", "user", "username", "password"));

    @Override
    public boolean acceptURL(String url) {
        if (url == null) {
            return false;
        }
        for (String scheme : this.getInternalAcceptedSchemes()) {
            if (!url.startsWith(scheme)) continue;
            return true;
        }
        return false;
    }

    @Override
    public UrlParser getUrlParser() {
        return new LindormLikeUrlParser();
    }

    @Override
    public Set<String> getAcceptedSchemes() {
        return this.acceptedSchemes;
    }

    public void setAcceptedSchemes(Set<String> acceptedSchemes) {
        this.acceptedSchemes = acceptedSchemes;
    }

    public Set<String> getInternalAcceptedSchemes() {
        return this.internalAcceptedSchemes;
    }

    public void setInternalAcceptedSchemes(Set<String> internalAcceptedSchemes) {
        this.internalAcceptedSchemes = internalAcceptedSchemes;
    }

    @Override
    public Set<String> getAcceptedPropertyKeys() {
        return this.acceptedPropertyKeys;
    }

    @Override
    public void setAcceptedPropertyKeys(Set<String> acceptedPropertyKeys) {
        this.acceptedPropertyKeys = acceptedPropertyKeys;
    }

    @Override
    public Set<String> getPropertyKeyWhiteList() {
        return this.propertyKeyWhiteList;
    }

    @Override
    public void setPropertyKeyWhiteList(Set<String> propertyKeyWhiteList) {
        this.propertyKeyWhiteList = propertyKeyWhiteList;
    }
}

