/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.filters;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.jdbc.UrlParser;
import com.aliyun.securitysdk.jdbc.filters.DefaultFilter;
import com.aliyun.securitysdk.jdbc.parser.Hive2Parser;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class Hive2Filter
extends DefaultFilter {
    private static final Logger logger = SecurityLogManager.getLogger(Hive2Filter.class);
    private Set<String> acceptedSchemes = new HashSet<String>(Collections.singletonList("jdbc:hive2:"));
    private Set<String> acceptedPropertyKeys = new HashSet<String>(Arrays.asList("retries", "sasl.qop", "user", "password", "principal", "ssl", "hive.server2.transport.mode", "transportMode", "hive.server2.thrift.http.path", "httpPath", "serviceDiscoveryMode", "zooKeeperNamespace", "cookieAuth", "cookieName", "fetchSize", "applicationName", "ApplicationName", "twoWay", "auth", "token", "compute-group", "spark.driver.memory", "spark.driver.memoryOverhead", "spark.kubernetes.driver.disk.size", "spark.executor.cores", "spark.executor.memory", "spark.executor.memoryOverhead", "spark.kubernetes.executor.disk.size", "spark.driver.resourceTag", "spark.executor.resourceTag", "spark.kubernetes.driver.ecsModelPreference", "spark.kubernetes.executor.ecsModelPreference", "spark.kubernetes.driver.annotation.k8s.aliyun.com/eci-use-specs", "spark.kubernetes.executor.annotation.k8s.aliyun.com/eci-use-specs", "spark.driver.resource.gpu.vendor", "spark.executor.resource.gpu.vendor", "spark.driver.resource.gpu.amount", "spark.executor.resource.gpu.amount", "spark.driver.resource.gpu.discoveryScript", "spark.executor.resource.gpu.discoveryScript", "spark.kubernetes.executor.annotation.k8s.aliyun.com/eci-use-specs", "spark.executor.instances", "spark.dynamicAllocation.enabled", "spark.dynamicAllocation.minExecutors", "spark.dynamicAllocation.maxExecutors", "spark.dynamicAllocation.executorIdleTimeout", "spark.speculation", "spark.task.maxFailures", "spark.dfsLog.executor.enabled", "spark.default.parallelism", "spark.sql.shuffle.partitions"));
    private Set<String> propertyKeyWhiteList = new HashSet<String>(Arrays.asList("user", "password", "principal"));
    private static final Map<String, Pattern> propertyPatterns = new HashMap<String, Pattern>();

    @Override
    protected Map<String, Pattern> getPropertyPatterns() {
        return propertyPatterns;
    }

    @Override
    public UrlParser getUrlParser() {
        return new Hive2Parser();
    }

    @Override
    public boolean checkAndFilterProperties(UrlParser parser) {
        if (!(parser instanceof Hive2Parser)) {
            throw new RuntimeException("param error, expected Hive2Parser");
        }
        HashMap removedProperties = new HashMap();
        Hive2Parser hive2Parser = (Hive2Parser)parser;
        List<Map> properties = Arrays.asList(hive2Parser.getSessionVars(), hive2Parser.getHiveConfs(), hive2Parser.getHiveVars());
        for (Map property : properties) {
            Iterator iterator = property.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String key = (String)entry.getKey();
                if (!this.keyIn(key, this.getAcceptedPropertyKeys()) && !key.startsWith("http.cookie.")) {
                    iterator.remove();
                    removedProperties.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (entry.getValue() == null || ((String)entry.getValue()).isEmpty() || this.keyIn(key, this.getPropertyKeyWhiteList()) || this.getPropertyValuePattern().matcher((CharSequence)entry.getValue()).matches()) continue;
                iterator.remove();
                removedProperties.put(key, entry.getValue());
            }
        }
        if (!removedProperties.isEmpty()) {
            logger.info("some invalid property are removed by jdbc url filter: {}, original url: {}, after filter: {}", removedProperties, (Object)parser.getInitialUrl(), (Object)parser.toString());
            return false;
        }
        return true;
    }

    @Override
    public Set<String> getAcceptedSchemes() {
        return this.acceptedSchemes;
    }

    public void setAcceptedSchemes(Set<String> acceptedSchemes) {
        this.acceptedSchemes = acceptedSchemes;
    }

    @Override
    public Set<String> getAcceptedPropertyKeys() {
        return this.acceptedPropertyKeys;
    }

    @Override
    public void setAcceptedPropertyKeys(Set<String> acceptedPropertyKeys) {
        this.acceptedPropertyKeys = acceptedPropertyKeys;
    }

    @Override
    public Set<String> getPropertyKeyWhiteList() {
        return this.propertyKeyWhiteList;
    }

    @Override
    public void setPropertyKeyWhiteList(Set<String> propertyKeyWhiteList) {
        this.propertyKeyWhiteList = propertyKeyWhiteList;
    }

    static {
        Pattern httpPathPattern = Pattern.compile("^[a-zA-Z0-9_\\-\\.:\\[\\]/]+$");
        propertyPatterns.put("httpPath", httpPathPattern);
        propertyPatterns.put("httpPathhive.server2.thrift.http.path", httpPathPattern);
    }
}

