/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.jdbc.Filter;
import com.aliyun.securitysdk.jdbc.FilterManager;
import com.aliyun.securitysdk.jdbc.JdbcTool;
import com.aliyun.securitysdk.jdbc.JdbcURLException;
import com.aliyun.securitysdk.jdbc.JdbcURLNotSupportedException;
import com.aliyun.securitysdk.jdbc.JdbcURLUnsafeException;
import com.aliyun.securitysdk.jdbc.UrlParser;
import com.aliyun.securitysdk.jdbc.filters.ArrowFlightSqlFilter;
import com.aliyun.securitysdk.jdbc.filters.As400Filter;
import com.aliyun.securitysdk.jdbc.filters.BigQueryFilter;
import com.aliyun.securitysdk.jdbc.filters.ClickHouseFilter;
import com.aliyun.securitysdk.jdbc.filters.ColonSeparatedUrlFilter;
import com.aliyun.securitysdk.jdbc.filters.DB2Filter;
import com.aliyun.securitysdk.jdbc.filters.DMFilter;
import com.aliyun.securitysdk.jdbc.filters.DefaultFilter;
import com.aliyun.securitysdk.jdbc.filters.ElasticSearchFilter;
import com.aliyun.securitysdk.jdbc.filters.GreenplumFilter;
import com.aliyun.securitysdk.jdbc.filters.Hive2Filter;
import com.aliyun.securitysdk.jdbc.filters.HiveFilter;
import com.aliyun.securitysdk.jdbc.filters.ImpalaFilter;
import com.aliyun.securitysdk.jdbc.filters.InformixSqliFilter;
import com.aliyun.securitysdk.jdbc.filters.KylinFilter;
import com.aliyun.securitysdk.jdbc.filters.LindormFilter;
import com.aliyun.securitysdk.jdbc.filters.MongoDBFilter;
import com.aliyun.securitysdk.jdbc.filters.MySQLFilter;
import com.aliyun.securitysdk.jdbc.filters.NSFilter;
import com.aliyun.securitysdk.jdbc.filters.OTSFilter;
import com.aliyun.securitysdk.jdbc.filters.OdpsFilter;
import com.aliyun.securitysdk.jdbc.filters.OracleFilter;
import com.aliyun.securitysdk.jdbc.filters.PhoenixThinFilter;
import com.aliyun.securitysdk.jdbc.filters.PostgresFilter;
import com.aliyun.securitysdk.jdbc.filters.PrestoFilter;
import com.aliyun.securitysdk.jdbc.filters.RedisFilter;
import com.aliyun.securitysdk.jdbc.filters.RedshiftFilter;
import com.aliyun.securitysdk.jdbc.filters.SAPFilter;
import com.aliyun.securitysdk.jdbc.filters.SQLServerFilter;
import com.aliyun.securitysdk.jdbc.filters.SemicolonSeparatedUrlFilter;
import com.aliyun.securitysdk.jdbc.filters.SnowFlakeFilter;
import com.aliyun.securitysdk.jdbc.filters.SybaseFilter;
import com.aliyun.securitysdk.jdbc.filters.TDEngineFilter;
import com.aliyun.securitysdk.jdbc.filters.TddlFilter;
import com.aliyun.securitysdk.jdbc.filters.TeradataFilter;
import com.aliyun.securitysdk.jdbc.filters.TrinoFilter;
import com.aliyun.securitysdk.jdbc.filters.UCanAccessFilter;
import com.aliyun.securitysdk.jdbc.filters.VerticaFilter;
import java.util.concurrent.atomic.AtomicBoolean;

public class JdbcToolImpl
implements JdbcTool {
    private static final Logger logger = SecurityLogManager.getLogger(JdbcToolImpl.class);
    private static final AtomicBoolean isInit = new AtomicBoolean(false);
    private static final FilterManager filterManager = new FilterManager();

    private static void init() {
        if (isInit.compareAndSet(false, true)) {
            filterManager.registerFilter(new BigQueryFilter());
            filterManager.registerFilter(new PhoenixThinFilter());
            filterManager.registerFilter(new KylinFilter());
            filterManager.registerFilter(new ElasticSearchFilter());
            filterManager.registerFilter(new OTSFilter());
            filterManager.registerFilter(new TDEngineFilter());
            filterManager.registerFilter(new ArrowFlightSqlFilter());
            filterManager.registerFilter(new SnowFlakeFilter());
            filterManager.registerFilter(new As400Filter());
            filterManager.registerFilter(new SybaseFilter());
            filterManager.registerFilter(new GreenplumFilter());
            filterManager.registerFilter(new VerticaFilter());
            filterManager.registerFilter(new ImpalaFilter());
            filterManager.registerFilter(new PrestoFilter());
            filterManager.registerFilter(new TrinoFilter());
            filterManager.registerFilter(new RedshiftFilter());
            filterManager.registerFilter(new Hive2Filter());
            filterManager.registerFilter(new HiveFilter());
            filterManager.registerFilter(new LindormFilter());
            filterManager.registerFilter(new TddlFilter());
            filterManager.registerFilter(new RedisFilter());
            filterManager.registerFilter(new TeradataFilter());
            filterManager.registerFilter(new MongoDBFilter());
            filterManager.registerFilter(new OracleFilter());
            filterManager.registerFilter(new MySQLFilter());
            filterManager.registerFilter(new PostgresFilter());
            filterManager.registerFilter(new SQLServerFilter());
            filterManager.registerFilter(new ClickHouseFilter());
            filterManager.registerFilter(new OdpsFilter());
            filterManager.registerFilter(new InformixSqliFilter());
            filterManager.registerFilter(new SAPFilter());
            filterManager.registerFilter(new NSFilter());
            filterManager.registerFilter(new UCanAccessFilter());
            filterManager.registerFilter(new DB2Filter());
            filterManager.registerFilter(new SemicolonSeparatedUrlFilter());
            filterManager.registerFilter(new ColonSeparatedUrlFilter());
            filterManager.registerFilter(new DMFilter());
            filterManager.registerFilter(new DefaultFilter());
        }
    }

    public void registerFilter(Filter filter) {
        filterManager.registerFilter(filter);
    }

    public String filterConnectionSource(String str) throws JdbcURLException {
        Filter filter = filterManager.selectFilter(str);
        UrlParser urlParser = filter.getUrlParser();
        urlParser.parse(str);
        filter.filterProperties(urlParser);
        return urlParser.toString();
    }

    public boolean isConnectionSourceSafe(String str) {
        try {
            Filter filter = filterManager.selectFilter(str);
            if (!(filter instanceof DefaultFilter)) {
                throw new JdbcURLUnsafeException("unknown filter, url: " + str);
            }
            UrlParser urlParser = filter.getUrlParser();
            urlParser.parse(str);
            return ((DefaultFilter)filter).checkAndFilterProperties(urlParser);
        }
        catch (JdbcURLNotSupportedException e) {
            logger.warn("jdbc url not supported ", (Object)e.getMessage());
            return true;
        }
        catch (JdbcURLException e) {
            logger.info(e.getMessage());
            return false;
        }
    }

    static {
        JdbcToolImpl.init();
    }
}

