/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc;

import com.aliyun.securitysdk.jdbc.Filter;
import com.aliyun.securitysdk.jdbc.JdbcURLException;
import com.aliyun.securitysdk.jdbc.JdbcURLNotSupportedException;
import com.aliyun.securitysdk.jdbc.JdbcURLUnsafeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FilterManager {
    private Map<String, Filter> schemaFilterMap = new HashMap<String, Filter>();
    private List<Filter> specialCaseFilters = new ArrayList<Filter>();

    public void registerFilter(Filter filter) {
        if (filter.getAcceptedSchemes() == null || filter.getAcceptedSchemes().isEmpty()) {
            this.specialCaseFilters.add(filter);
        } else {
            for (String scheme : filter.getAcceptedSchemes()) {
                this.schemaFilterMap.put(scheme, filter);
            }
        }
    }

    public Filter selectFilter(String url) throws JdbcURLException {
        if (url == null) {
            throw new JdbcURLUnsafeException("url should not be null");
        }
        for (int i = this.specialCaseFilters.size() - 1; i >= 0; --i) {
            Filter filter = this.specialCaseFilters.get(i);
            if (!filter.acceptURL(url)) continue;
            return filter;
        }
        int separator = url.indexOf("//");
        if (separator == -1) {
            throw new JdbcURLUnsafeException("parsing url error : '//' is not present in the url " + url);
        }
        String scheme = url.substring(0, separator).toLowerCase();
        if (this.schemaFilterMap.get(scheme) != null) {
            return this.schemaFilterMap.get(scheme);
        }
        if (scheme.equalsIgnoreCase("jdbc:mysql:fabric:") || scheme.regionMatches(true, 0, "jdbc:jcr:jndi:", 0, "jdbc:jcr:jndi:".length())) {
            throw new JdbcURLUnsafeException("protocol is unsafe to use");
        }
        throw new JdbcURLNotSupportedException("scheme  " + scheme + " not supported, url: " + url);
    }
}

