/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.adf.reader.handle;

import com.aliyun.dataworks.migrationx.domain.adf.AdfPackage;
import com.aliyun.dataworks.migrationx.domain.adf.AdfPackageLoader;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.workflow.adf.reader.convert.AdfConverter;
import com.aliyun.migration.workflow.adf.reader.handle.AdfPackageHandle;
import com.aliyun.migrationx.common.utils.ZipUtils;
import java.io.File;
import java.io.IOException;

public class AdfFileHandle
extends AdfPackageHandle {
    private AdfPackageLoader adfPackageLoader;
    private AdfPackage adfPackage = new AdfPackage();
    private AdfConverter adfConverter = new AdfConverter();

    public AdfFileHandle(Datasource scheduleDataSource, TaskContext taskContext) {
        super(scheduleDataSource, taskContext);
    }

    @Override
    public void init() {
        File unzippedDir;
        String sourceFilePackage = this.taskContext.getSourceFilePackage();
        File packageFile = new File(sourceFilePackage);
        if (packageFile.isFile()) {
            try {
                unzippedDir = ZipUtils.decompress((File)packageFile);
            }
            catch (IOException e) {
                throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.FILE_NOT_FOUND, (String)e.getMessage());
            }
            File localDir = new File(packageFile.getAbsolutePath().replaceAll("\\.\\w+$", ""));
            unzippedDir = new File(unzippedDir, localDir.getName());
        } else {
            unzippedDir = packageFile;
        }
        this.adfPackageLoader = new AdfPackageLoader(unzippedDir);
        this.adfPackage.setPackageRoot(unzippedDir);
        this.adfPackage.setPipelines(this.adfPackageLoader.getPipelines());
        this.adfPackage.setTriggers(this.adfPackageLoader.getTriggers());
        this.adfPackage.setLinkedServices(this.adfPackageLoader.getLinkedServices());
    }

    @Override
    public WorkflowProjectPackage read() throws Exception {
        WorkflowProjectPackage workflowProjectPackage = this.adfConverter.convert(this.adfPackage);
        return workflowProjectPackage;
    }
}

